/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListTrafficPoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListTrafficPoliciesRequestMarshaller
implements Marshaller<Request<ListTrafficPoliciesRequest>, ListTrafficPoliciesRequest> {
    @Override
    public Request<ListTrafficPoliciesRequest> marshall(ListTrafficPoliciesRequest listTrafficPoliciesRequest) {
        if (listTrafficPoliciesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTrafficPoliciesRequest> request = new DefaultRequest<ListTrafficPoliciesRequest>(listTrafficPoliciesRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/trafficpolicies";
        request.setResourcePath(uriResourcePath);
        if (listTrafficPoliciesRequest.getTrafficPolicyIdMarker() != null) {
            request.addParameter("trafficpolicyid", StringUtils.fromString(listTrafficPoliciesRequest.getTrafficPolicyIdMarker()));
        }
        if (listTrafficPoliciesRequest.getMaxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString(listTrafficPoliciesRequest.getMaxItems()));
        }
        return request;
    }
}

