/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.CreateDeploymentRequest;
import com.amazonaws.services.opsworks.model.transform.DeploymentCommandJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class CreateDeploymentRequestMarshaller
implements Marshaller<Request<CreateDeploymentRequest>, CreateDeploymentRequest> {
    @Override
    public Request<CreateDeploymentRequest> marshall(CreateDeploymentRequest createDeploymentRequest) {
        if (createDeploymentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDeploymentRequest> request = new DefaultRequest<CreateDeploymentRequest>(createDeploymentRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.CreateDeployment");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList instanceIdsList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (createDeploymentRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(createDeploymentRequest.getStackId());
            }
            if (createDeploymentRequest.getAppId() != null) {
                jsonGenerator.writeFieldName("AppId").writeValue(createDeploymentRequest.getAppId());
            }
            if (!(instanceIdsList = (SdkInternalList)createDeploymentRequest.getInstanceIds()).isEmpty() || !instanceIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstanceIds");
                jsonGenerator.writeStartArray();
                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue == null) continue;
                    jsonGenerator.writeValue(instanceIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (createDeploymentRequest.getCommand() != null) {
                jsonGenerator.writeFieldName("Command");
                DeploymentCommandJsonMarshaller.getInstance().marshall(createDeploymentRequest.getCommand(), jsonGenerator);
            }
            if (createDeploymentRequest.getComment() != null) {
                jsonGenerator.writeFieldName("Comment").writeValue(createDeploymentRequest.getComment());
            }
            if (createDeploymentRequest.getCustomJson() != null) {
                jsonGenerator.writeFieldName("CustomJson").writeValue(createDeploymentRequest.getCustomJson());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

