/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.kms.model.GrantConstraints;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.Map;

public class GrantConstraintsJsonMarshaller {
    private static GrantConstraintsJsonMarshaller instance;

    public void marshall(GrantConstraints grantConstraints, StructuredJsonGenerator jsonGenerator) {
        if (grantConstraints == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalMap encryptionContextEqualsMap;
            jsonGenerator.writeStartObject();
            SdkInternalMap encryptionContextSubsetMap = (SdkInternalMap)grantConstraints.getEncryptionContextSubset();
            if (!encryptionContextSubsetMap.isEmpty() || !encryptionContextSubsetMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("EncryptionContextSubset");
                jsonGenerator.writeStartObject();
                for (Map.Entry encryptionContextSubsetMapValue : encryptionContextSubsetMap.entrySet()) {
                    if (encryptionContextSubsetMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)encryptionContextSubsetMapValue.getKey());
                    jsonGenerator.writeValue((String)encryptionContextSubsetMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (!(encryptionContextEqualsMap = (SdkInternalMap)grantConstraints.getEncryptionContextEquals()).isEmpty() || !encryptionContextEqualsMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("EncryptionContextEquals");
                jsonGenerator.writeStartObject();
                for (Map.Entry encryptionContextEqualsMapValue : encryptionContextEqualsMap.entrySet()) {
                    if (encryptionContextEqualsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)encryptionContextEqualsMapValue.getKey());
                    jsonGenerator.writeValue((String)encryptionContextEqualsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GrantConstraintsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GrantConstraintsJsonMarshaller();
        }
        return instance;
    }
}

