/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListCACertificatesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListCACertificatesRequestMarshaller
implements Marshaller<Request<ListCACertificatesRequest>, ListCACertificatesRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<ListCACertificatesRequest> marshall(ListCACertificatesRequest listCACertificatesRequest) {
        if (listCACertificatesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListCACertificatesRequest> request = new DefaultRequest<ListCACertificatesRequest>(listCACertificatesRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/cacertificates";
        request.setResourcePath(uriResourcePath);
        if (listCACertificatesRequest.getPageSize() != null) {
            request.addParameter("pageSize", StringUtils.fromInteger(listCACertificatesRequest.getPageSize()));
        }
        if (listCACertificatesRequest.getMarker() != null) {
            request.addParameter("marker", StringUtils.fromString(listCACertificatesRequest.getMarker()));
        }
        if (listCACertificatesRequest.getAscendingOrder() != null) {
            request.addParameter("isAscendingOrder", StringUtils.fromBoolean(listCACertificatesRequest.getAscendingOrder()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

