/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.iot.model.Action;
import com.amazonaws.services.iot.model.transform.CloudwatchAlarmActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.CloudwatchMetricActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.DynamoDBActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.ElasticsearchActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.FirehoseActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.KinesisActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.LambdaActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.RepublishActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.S3ActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.SnsActionJsonMarshaller;
import com.amazonaws.services.iot.model.transform.SqsActionJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class ActionJsonMarshaller {
    private static ActionJsonMarshaller instance;

    public void marshall(Action action, StructuredJsonGenerator jsonGenerator) {
        if (action == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (action.getDynamoDB() != null) {
                jsonGenerator.writeFieldName("dynamoDB");
                DynamoDBActionJsonMarshaller.getInstance().marshall(action.getDynamoDB(), jsonGenerator);
            }
            if (action.getLambda() != null) {
                jsonGenerator.writeFieldName("lambda");
                LambdaActionJsonMarshaller.getInstance().marshall(action.getLambda(), jsonGenerator);
            }
            if (action.getSns() != null) {
                jsonGenerator.writeFieldName("sns");
                SnsActionJsonMarshaller.getInstance().marshall(action.getSns(), jsonGenerator);
            }
            if (action.getSqs() != null) {
                jsonGenerator.writeFieldName("sqs");
                SqsActionJsonMarshaller.getInstance().marshall(action.getSqs(), jsonGenerator);
            }
            if (action.getKinesis() != null) {
                jsonGenerator.writeFieldName("kinesis");
                KinesisActionJsonMarshaller.getInstance().marshall(action.getKinesis(), jsonGenerator);
            }
            if (action.getRepublish() != null) {
                jsonGenerator.writeFieldName("republish");
                RepublishActionJsonMarshaller.getInstance().marshall(action.getRepublish(), jsonGenerator);
            }
            if (action.getS3() != null) {
                jsonGenerator.writeFieldName("s3");
                S3ActionJsonMarshaller.getInstance().marshall(action.getS3(), jsonGenerator);
            }
            if (action.getFirehose() != null) {
                jsonGenerator.writeFieldName("firehose");
                FirehoseActionJsonMarshaller.getInstance().marshall(action.getFirehose(), jsonGenerator);
            }
            if (action.getCloudwatchMetric() != null) {
                jsonGenerator.writeFieldName("cloudwatchMetric");
                CloudwatchMetricActionJsonMarshaller.getInstance().marshall(action.getCloudwatchMetric(), jsonGenerator);
            }
            if (action.getCloudwatchAlarm() != null) {
                jsonGenerator.writeFieldName("cloudwatchAlarm");
                CloudwatchAlarmActionJsonMarshaller.getInstance().marshall(action.getCloudwatchAlarm(), jsonGenerator);
            }
            if (action.getElasticsearch() != null) {
                jsonGenerator.writeFieldName("elasticsearch");
                ElasticsearchActionJsonMarshaller.getInstance().marshall(action.getElasticsearch(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActionJsonMarshaller();
        }
        return instance;
    }
}

