/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeAddressesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeAddressesRequestMarshaller
implements Marshaller<Request<DescribeAddressesRequest>, DescribeAddressesRequest> {
    @Override
    public Request<DescribeAddressesRequest> marshall(DescribeAddressesRequest describeAddressesRequest) {
        SdkInternalList allocationIdsList;
        SdkInternalList filtersList;
        if (describeAddressesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeAddressesRequest> request = new DefaultRequest<DescribeAddressesRequest>(describeAddressesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeAddresses");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList publicIpsList = (SdkInternalList)describeAddressesRequest.getPublicIps();
        if (!publicIpsList.isEmpty() || !publicIpsList.isAutoConstruct()) {
            int publicIpsListIndex = 1;
            for (String publicIpsListValue : publicIpsList) {
                if (publicIpsListValue != null) {
                    request.addParameter("PublicIp." + publicIpsListIndex, StringUtils.fromString(publicIpsListValue));
                }
                ++publicIpsListIndex;
            }
        }
        if (!(filtersList = (SdkInternalList)describeAddressesRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(allocationIdsList = (SdkInternalList)describeAddressesRequest.getAllocationIds()).isEmpty() || !allocationIdsList.isAutoConstruct()) {
            int allocationIdsListIndex = 1;
            for (String allocationIdsListValue : allocationIdsList) {
                if (allocationIdsListValue != null) {
                    request.addParameter("AllocationId." + allocationIdsListIndex, StringUtils.fromString(allocationIdsListValue));
                }
                ++allocationIdsListIndex;
            }
        }
        return request;
    }
}

