/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directory.model.DeleteTrustRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class DeleteTrustRequestMarshaller
implements Marshaller<Request<DeleteTrustRequest>, DeleteTrustRequest> {
    @Override
    public Request<DeleteTrustRequest> marshall(DeleteTrustRequest deleteTrustRequest) {
        if (deleteTrustRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteTrustRequest> request = new DefaultRequest<DeleteTrustRequest>(deleteTrustRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.DeleteTrust");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (deleteTrustRequest.getTrustId() != null) {
                jsonGenerator.writeFieldName("TrustId").writeValue(deleteTrustRequest.getTrustId());
            }
            if (deleteTrustRequest.getDeleteAssociatedConditionalForwarder() != null) {
                jsonGenerator.writeFieldName("DeleteAssociatedConditionalForwarder").writeValue(deleteTrustRequest.getDeleteAssociatedConditionalForwarder());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

