/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidp.model.AddCustomAttributesRequest;
import com.amazonaws.services.cognitoidp.model.SchemaAttributeType;
import com.amazonaws.services.cognitoidp.model.transform.SchemaAttributeTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.List;

public class AddCustomAttributesRequestMarshaller
implements Marshaller<Request<AddCustomAttributesRequest>, AddCustomAttributesRequest> {
    @Override
    public Request<AddCustomAttributesRequest> marshall(AddCustomAttributesRequest addCustomAttributesRequest) {
        if (addCustomAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddCustomAttributesRequest> request = new DefaultRequest<AddCustomAttributesRequest>(addCustomAttributesRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.AddCustomAttributes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<SchemaAttributeType> customAttributesList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (addCustomAttributesRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(addCustomAttributesRequest.getUserPoolId());
            }
            if ((customAttributesList = addCustomAttributesRequest.getCustomAttributes()) != null) {
                jsonGenerator.writeFieldName("CustomAttributes");
                jsonGenerator.writeStartArray();
                for (SchemaAttributeType customAttributesListValue : customAttributesList) {
                    if (customAttributesListValue == null) continue;
                    SchemaAttributeTypeJsonMarshaller.getInstance().marshall(customAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

