/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.autoscaling.AmazonAutoScalingAsync;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.autoscaling.model.AttachInstancesRequest;
import com.amazonaws.services.autoscaling.model.AttachLoadBalancersRequest;
import com.amazonaws.services.autoscaling.model.AttachLoadBalancersResult;
import com.amazonaws.services.autoscaling.model.CompleteLifecycleActionRequest;
import com.amazonaws.services.autoscaling.model.CompleteLifecycleActionResult;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest;
import com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DeleteLifecycleHookRequest;
import com.amazonaws.services.autoscaling.model.DeleteLifecycleHookResult;
import com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DeletePolicyRequest;
import com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest;
import com.amazonaws.services.autoscaling.model.DeleteTagsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAccountLimitsResult;
import com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesResult;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesResult;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesResult;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsResult;
import com.amazonaws.services.autoscaling.model.DescribeLifecycleHookTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeLifecycleHookTypesResult;
import com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksRequest;
import com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksResult;
import com.amazonaws.services.autoscaling.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.autoscaling.model.DescribeLoadBalancersResult;
import com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesResult;
import com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsResult;
import com.amazonaws.services.autoscaling.model.DescribePoliciesRequest;
import com.amazonaws.services.autoscaling.model.DescribePoliciesResult;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesResult;
import com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesResult;
import com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest;
import com.amazonaws.services.autoscaling.model.DescribeScheduledActionsResult;
import com.amazonaws.services.autoscaling.model.DescribeTagsRequest;
import com.amazonaws.services.autoscaling.model.DescribeTagsResult;
import com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest;
import com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesResult;
import com.amazonaws.services.autoscaling.model.DetachInstancesRequest;
import com.amazonaws.services.autoscaling.model.DetachInstancesResult;
import com.amazonaws.services.autoscaling.model.DetachLoadBalancersRequest;
import com.amazonaws.services.autoscaling.model.DetachLoadBalancersResult;
import com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest;
import com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest;
import com.amazonaws.services.autoscaling.model.EnterStandbyRequest;
import com.amazonaws.services.autoscaling.model.EnterStandbyResult;
import com.amazonaws.services.autoscaling.model.ExecutePolicyRequest;
import com.amazonaws.services.autoscaling.model.ExitStandbyRequest;
import com.amazonaws.services.autoscaling.model.ExitStandbyResult;
import com.amazonaws.services.autoscaling.model.PutLifecycleHookRequest;
import com.amazonaws.services.autoscaling.model.PutLifecycleHookResult;
import com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest;
import com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest;
import com.amazonaws.services.autoscaling.model.PutScalingPolicyResult;
import com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import com.amazonaws.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest;
import com.amazonaws.services.autoscaling.model.RecordLifecycleActionHeartbeatResult;
import com.amazonaws.services.autoscaling.model.ResumeProcessesRequest;
import com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest;
import com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest;
import com.amazonaws.services.autoscaling.model.SetInstanceProtectionRequest;
import com.amazonaws.services.autoscaling.model.SetInstanceProtectionResult;
import com.amazonaws.services.autoscaling.model.SuspendProcessesRequest;
import com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResult;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonAutoScalingAsyncClient
extends AmazonAutoScalingClient
implements AmazonAutoScalingAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonAutoScalingAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonAutoScalingAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonAutoScalingAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonAutoScalingAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonAutoScalingAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonAutoScalingAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonAutoScalingAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonAutoScalingAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonAutoScalingAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<Void> attachInstancesAsync(AttachInstancesRequest request) {
        return this.attachInstancesAsync(request, null);
    }

    @Override
    public Future<Void> attachInstancesAsync(final AttachInstancesRequest request, final AsyncHandler<AttachInstancesRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.attachInstances(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AttachLoadBalancersResult> attachLoadBalancersAsync(AttachLoadBalancersRequest request) {
        return this.attachLoadBalancersAsync(request, null);
    }

    @Override
    public Future<AttachLoadBalancersResult> attachLoadBalancersAsync(final AttachLoadBalancersRequest request, final AsyncHandler<AttachLoadBalancersRequest, AttachLoadBalancersResult> asyncHandler) {
        return this.executorService.submit(new Callable<AttachLoadBalancersResult>(){

            @Override
            public AttachLoadBalancersResult call() throws Exception {
                AttachLoadBalancersResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.attachLoadBalancers(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AttachLoadBalancersResult> attachLoadBalancersAsync() {
        return this.attachLoadBalancersAsync(new AttachLoadBalancersRequest());
    }

    @Override
    public Future<AttachLoadBalancersResult> attachLoadBalancersAsync(AsyncHandler<AttachLoadBalancersRequest, AttachLoadBalancersResult> asyncHandler) {
        return this.attachLoadBalancersAsync(new AttachLoadBalancersRequest(), asyncHandler);
    }

    @Override
    public Future<CompleteLifecycleActionResult> completeLifecycleActionAsync(CompleteLifecycleActionRequest request) {
        return this.completeLifecycleActionAsync(request, null);
    }

    @Override
    public Future<CompleteLifecycleActionResult> completeLifecycleActionAsync(final CompleteLifecycleActionRequest request, final AsyncHandler<CompleteLifecycleActionRequest, CompleteLifecycleActionResult> asyncHandler) {
        return this.executorService.submit(new Callable<CompleteLifecycleActionResult>(){

            @Override
            public CompleteLifecycleActionResult call() throws Exception {
                CompleteLifecycleActionResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.completeLifecycleAction(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> createAutoScalingGroupAsync(CreateAutoScalingGroupRequest request) {
        return this.createAutoScalingGroupAsync(request, null);
    }

    @Override
    public Future<Void> createAutoScalingGroupAsync(final CreateAutoScalingGroupRequest request, final AsyncHandler<CreateAutoScalingGroupRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.createAutoScalingGroup(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> createLaunchConfigurationAsync(CreateLaunchConfigurationRequest request) {
        return this.createLaunchConfigurationAsync(request, null);
    }

    @Override
    public Future<Void> createLaunchConfigurationAsync(final CreateLaunchConfigurationRequest request, final AsyncHandler<CreateLaunchConfigurationRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.createLaunchConfiguration(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> createOrUpdateTagsAsync(CreateOrUpdateTagsRequest request) {
        return this.createOrUpdateTagsAsync(request, null);
    }

    @Override
    public Future<Void> createOrUpdateTagsAsync(final CreateOrUpdateTagsRequest request, final AsyncHandler<CreateOrUpdateTagsRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.createOrUpdateTags(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteAutoScalingGroupAsync(DeleteAutoScalingGroupRequest request) {
        return this.deleteAutoScalingGroupAsync(request, null);
    }

    @Override
    public Future<Void> deleteAutoScalingGroupAsync(final DeleteAutoScalingGroupRequest request, final AsyncHandler<DeleteAutoScalingGroupRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.deleteAutoScalingGroup(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteLaunchConfigurationAsync(DeleteLaunchConfigurationRequest request) {
        return this.deleteLaunchConfigurationAsync(request, null);
    }

    @Override
    public Future<Void> deleteLaunchConfigurationAsync(final DeleteLaunchConfigurationRequest request, final AsyncHandler<DeleteLaunchConfigurationRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.deleteLaunchConfiguration(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLifecycleHookResult> deleteLifecycleHookAsync(DeleteLifecycleHookRequest request) {
        return this.deleteLifecycleHookAsync(request, null);
    }

    @Override
    public Future<DeleteLifecycleHookResult> deleteLifecycleHookAsync(final DeleteLifecycleHookRequest request, final AsyncHandler<DeleteLifecycleHookRequest, DeleteLifecycleHookResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteLifecycleHookResult>(){

            @Override
            public DeleteLifecycleHookResult call() throws Exception {
                DeleteLifecycleHookResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.deleteLifecycleHook(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteNotificationConfigurationAsync(DeleteNotificationConfigurationRequest request) {
        return this.deleteNotificationConfigurationAsync(request, null);
    }

    @Override
    public Future<Void> deleteNotificationConfigurationAsync(final DeleteNotificationConfigurationRequest request, final AsyncHandler<DeleteNotificationConfigurationRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.deleteNotificationConfiguration(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deletePolicyAsync(DeletePolicyRequest request) {
        return this.deletePolicyAsync(request, null);
    }

    @Override
    public Future<Void> deletePolicyAsync(final DeletePolicyRequest request, final AsyncHandler<DeletePolicyRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.deletePolicy(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteScheduledActionAsync(DeleteScheduledActionRequest request) {
        return this.deleteScheduledActionAsync(request, null);
    }

    @Override
    public Future<Void> deleteScheduledActionAsync(final DeleteScheduledActionRequest request, final AsyncHandler<DeleteScheduledActionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.deleteScheduledAction(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteTagsAsync(DeleteTagsRequest request) {
        return this.deleteTagsAsync(request, null);
    }

    @Override
    public Future<Void> deleteTagsAsync(final DeleteTagsRequest request, final AsyncHandler<DeleteTagsRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.deleteTags(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAccountLimitsResult> describeAccountLimitsAsync(DescribeAccountLimitsRequest request) {
        return this.describeAccountLimitsAsync(request, null);
    }

    @Override
    public Future<DescribeAccountLimitsResult> describeAccountLimitsAsync(final DescribeAccountLimitsRequest request, final AsyncHandler<DescribeAccountLimitsRequest, DescribeAccountLimitsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAccountLimitsResult>(){

            @Override
            public DescribeAccountLimitsResult call() throws Exception {
                DescribeAccountLimitsResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeAccountLimits(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAccountLimitsResult> describeAccountLimitsAsync() {
        return this.describeAccountLimitsAsync(new DescribeAccountLimitsRequest());
    }

    @Override
    public Future<DescribeAccountLimitsResult> describeAccountLimitsAsync(AsyncHandler<DescribeAccountLimitsRequest, DescribeAccountLimitsResult> asyncHandler) {
        return this.describeAccountLimitsAsync(new DescribeAccountLimitsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeAdjustmentTypesResult> describeAdjustmentTypesAsync(DescribeAdjustmentTypesRequest request) {
        return this.describeAdjustmentTypesAsync(request, null);
    }

    @Override
    public Future<DescribeAdjustmentTypesResult> describeAdjustmentTypesAsync(final DescribeAdjustmentTypesRequest request, final AsyncHandler<DescribeAdjustmentTypesRequest, DescribeAdjustmentTypesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAdjustmentTypesResult>(){

            @Override
            public DescribeAdjustmentTypesResult call() throws Exception {
                DescribeAdjustmentTypesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeAdjustmentTypes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAdjustmentTypesResult> describeAdjustmentTypesAsync() {
        return this.describeAdjustmentTypesAsync(new DescribeAdjustmentTypesRequest());
    }

    @Override
    public Future<DescribeAdjustmentTypesResult> describeAdjustmentTypesAsync(AsyncHandler<DescribeAdjustmentTypesRequest, DescribeAdjustmentTypesResult> asyncHandler) {
        return this.describeAdjustmentTypesAsync(new DescribeAdjustmentTypesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeAutoScalingGroupsResult> describeAutoScalingGroupsAsync(DescribeAutoScalingGroupsRequest request) {
        return this.describeAutoScalingGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeAutoScalingGroupsResult> describeAutoScalingGroupsAsync(final DescribeAutoScalingGroupsRequest request, final AsyncHandler<DescribeAutoScalingGroupsRequest, DescribeAutoScalingGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAutoScalingGroupsResult>(){

            @Override
            public DescribeAutoScalingGroupsResult call() throws Exception {
                DescribeAutoScalingGroupsResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeAutoScalingGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAutoScalingGroupsResult> describeAutoScalingGroupsAsync() {
        return this.describeAutoScalingGroupsAsync(new DescribeAutoScalingGroupsRequest());
    }

    @Override
    public Future<DescribeAutoScalingGroupsResult> describeAutoScalingGroupsAsync(AsyncHandler<DescribeAutoScalingGroupsRequest, DescribeAutoScalingGroupsResult> asyncHandler) {
        return this.describeAutoScalingGroupsAsync(new DescribeAutoScalingGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeAutoScalingInstancesResult> describeAutoScalingInstancesAsync(DescribeAutoScalingInstancesRequest request) {
        return this.describeAutoScalingInstancesAsync(request, null);
    }

    @Override
    public Future<DescribeAutoScalingInstancesResult> describeAutoScalingInstancesAsync(final DescribeAutoScalingInstancesRequest request, final AsyncHandler<DescribeAutoScalingInstancesRequest, DescribeAutoScalingInstancesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAutoScalingInstancesResult>(){

            @Override
            public DescribeAutoScalingInstancesResult call() throws Exception {
                DescribeAutoScalingInstancesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeAutoScalingInstances(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAutoScalingInstancesResult> describeAutoScalingInstancesAsync() {
        return this.describeAutoScalingInstancesAsync(new DescribeAutoScalingInstancesRequest());
    }

    @Override
    public Future<DescribeAutoScalingInstancesResult> describeAutoScalingInstancesAsync(AsyncHandler<DescribeAutoScalingInstancesRequest, DescribeAutoScalingInstancesResult> asyncHandler) {
        return this.describeAutoScalingInstancesAsync(new DescribeAutoScalingInstancesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeAutoScalingNotificationTypesResult> describeAutoScalingNotificationTypesAsync(DescribeAutoScalingNotificationTypesRequest request) {
        return this.describeAutoScalingNotificationTypesAsync(request, null);
    }

    @Override
    public Future<DescribeAutoScalingNotificationTypesResult> describeAutoScalingNotificationTypesAsync(final DescribeAutoScalingNotificationTypesRequest request, final AsyncHandler<DescribeAutoScalingNotificationTypesRequest, DescribeAutoScalingNotificationTypesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAutoScalingNotificationTypesResult>(){

            @Override
            public DescribeAutoScalingNotificationTypesResult call() throws Exception {
                DescribeAutoScalingNotificationTypesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeAutoScalingNotificationTypes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAutoScalingNotificationTypesResult> describeAutoScalingNotificationTypesAsync() {
        return this.describeAutoScalingNotificationTypesAsync(new DescribeAutoScalingNotificationTypesRequest());
    }

    @Override
    public Future<DescribeAutoScalingNotificationTypesResult> describeAutoScalingNotificationTypesAsync(AsyncHandler<DescribeAutoScalingNotificationTypesRequest, DescribeAutoScalingNotificationTypesResult> asyncHandler) {
        return this.describeAutoScalingNotificationTypesAsync(new DescribeAutoScalingNotificationTypesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeLaunchConfigurationsResult> describeLaunchConfigurationsAsync(DescribeLaunchConfigurationsRequest request) {
        return this.describeLaunchConfigurationsAsync(request, null);
    }

    @Override
    public Future<DescribeLaunchConfigurationsResult> describeLaunchConfigurationsAsync(final DescribeLaunchConfigurationsRequest request, final AsyncHandler<DescribeLaunchConfigurationsRequest, DescribeLaunchConfigurationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeLaunchConfigurationsResult>(){

            @Override
            public DescribeLaunchConfigurationsResult call() throws Exception {
                DescribeLaunchConfigurationsResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeLaunchConfigurations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLaunchConfigurationsResult> describeLaunchConfigurationsAsync() {
        return this.describeLaunchConfigurationsAsync(new DescribeLaunchConfigurationsRequest());
    }

    @Override
    public Future<DescribeLaunchConfigurationsResult> describeLaunchConfigurationsAsync(AsyncHandler<DescribeLaunchConfigurationsRequest, DescribeLaunchConfigurationsResult> asyncHandler) {
        return this.describeLaunchConfigurationsAsync(new DescribeLaunchConfigurationsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeLifecycleHookTypesResult> describeLifecycleHookTypesAsync(DescribeLifecycleHookTypesRequest request) {
        return this.describeLifecycleHookTypesAsync(request, null);
    }

    @Override
    public Future<DescribeLifecycleHookTypesResult> describeLifecycleHookTypesAsync(final DescribeLifecycleHookTypesRequest request, final AsyncHandler<DescribeLifecycleHookTypesRequest, DescribeLifecycleHookTypesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeLifecycleHookTypesResult>(){

            @Override
            public DescribeLifecycleHookTypesResult call() throws Exception {
                DescribeLifecycleHookTypesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeLifecycleHookTypes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLifecycleHookTypesResult> describeLifecycleHookTypesAsync() {
        return this.describeLifecycleHookTypesAsync(new DescribeLifecycleHookTypesRequest());
    }

    @Override
    public Future<DescribeLifecycleHookTypesResult> describeLifecycleHookTypesAsync(AsyncHandler<DescribeLifecycleHookTypesRequest, DescribeLifecycleHookTypesResult> asyncHandler) {
        return this.describeLifecycleHookTypesAsync(new DescribeLifecycleHookTypesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeLifecycleHooksResult> describeLifecycleHooksAsync(DescribeLifecycleHooksRequest request) {
        return this.describeLifecycleHooksAsync(request, null);
    }

    @Override
    public Future<DescribeLifecycleHooksResult> describeLifecycleHooksAsync(final DescribeLifecycleHooksRequest request, final AsyncHandler<DescribeLifecycleHooksRequest, DescribeLifecycleHooksResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeLifecycleHooksResult>(){

            @Override
            public DescribeLifecycleHooksResult call() throws Exception {
                DescribeLifecycleHooksResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeLifecycleHooks(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLoadBalancersResult> describeLoadBalancersAsync(DescribeLoadBalancersRequest request) {
        return this.describeLoadBalancersAsync(request, null);
    }

    @Override
    public Future<DescribeLoadBalancersResult> describeLoadBalancersAsync(final DescribeLoadBalancersRequest request, final AsyncHandler<DescribeLoadBalancersRequest, DescribeLoadBalancersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeLoadBalancersResult>(){

            @Override
            public DescribeLoadBalancersResult call() throws Exception {
                DescribeLoadBalancersResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeLoadBalancers(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMetricCollectionTypesResult> describeMetricCollectionTypesAsync(DescribeMetricCollectionTypesRequest request) {
        return this.describeMetricCollectionTypesAsync(request, null);
    }

    @Override
    public Future<DescribeMetricCollectionTypesResult> describeMetricCollectionTypesAsync(final DescribeMetricCollectionTypesRequest request, final AsyncHandler<DescribeMetricCollectionTypesRequest, DescribeMetricCollectionTypesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeMetricCollectionTypesResult>(){

            @Override
            public DescribeMetricCollectionTypesResult call() throws Exception {
                DescribeMetricCollectionTypesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeMetricCollectionTypes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMetricCollectionTypesResult> describeMetricCollectionTypesAsync() {
        return this.describeMetricCollectionTypesAsync(new DescribeMetricCollectionTypesRequest());
    }

    @Override
    public Future<DescribeMetricCollectionTypesResult> describeMetricCollectionTypesAsync(AsyncHandler<DescribeMetricCollectionTypesRequest, DescribeMetricCollectionTypesResult> asyncHandler) {
        return this.describeMetricCollectionTypesAsync(new DescribeMetricCollectionTypesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeNotificationConfigurationsResult> describeNotificationConfigurationsAsync(DescribeNotificationConfigurationsRequest request) {
        return this.describeNotificationConfigurationsAsync(request, null);
    }

    @Override
    public Future<DescribeNotificationConfigurationsResult> describeNotificationConfigurationsAsync(final DescribeNotificationConfigurationsRequest request, final AsyncHandler<DescribeNotificationConfigurationsRequest, DescribeNotificationConfigurationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeNotificationConfigurationsResult>(){

            @Override
            public DescribeNotificationConfigurationsResult call() throws Exception {
                DescribeNotificationConfigurationsResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeNotificationConfigurations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeNotificationConfigurationsResult> describeNotificationConfigurationsAsync() {
        return this.describeNotificationConfigurationsAsync(new DescribeNotificationConfigurationsRequest());
    }

    @Override
    public Future<DescribeNotificationConfigurationsResult> describeNotificationConfigurationsAsync(AsyncHandler<DescribeNotificationConfigurationsRequest, DescribeNotificationConfigurationsResult> asyncHandler) {
        return this.describeNotificationConfigurationsAsync(new DescribeNotificationConfigurationsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribePoliciesResult> describePoliciesAsync(DescribePoliciesRequest request) {
        return this.describePoliciesAsync(request, null);
    }

    @Override
    public Future<DescribePoliciesResult> describePoliciesAsync(final DescribePoliciesRequest request, final AsyncHandler<DescribePoliciesRequest, DescribePoliciesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribePoliciesResult>(){

            @Override
            public DescribePoliciesResult call() throws Exception {
                DescribePoliciesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describePolicies(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePoliciesResult> describePoliciesAsync() {
        return this.describePoliciesAsync(new DescribePoliciesRequest());
    }

    @Override
    public Future<DescribePoliciesResult> describePoliciesAsync(AsyncHandler<DescribePoliciesRequest, DescribePoliciesResult> asyncHandler) {
        return this.describePoliciesAsync(new DescribePoliciesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeScalingActivitiesResult> describeScalingActivitiesAsync(DescribeScalingActivitiesRequest request) {
        return this.describeScalingActivitiesAsync(request, null);
    }

    @Override
    public Future<DescribeScalingActivitiesResult> describeScalingActivitiesAsync(final DescribeScalingActivitiesRequest request, final AsyncHandler<DescribeScalingActivitiesRequest, DescribeScalingActivitiesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeScalingActivitiesResult>(){

            @Override
            public DescribeScalingActivitiesResult call() throws Exception {
                DescribeScalingActivitiesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeScalingActivities(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeScalingActivitiesResult> describeScalingActivitiesAsync() {
        return this.describeScalingActivitiesAsync(new DescribeScalingActivitiesRequest());
    }

    @Override
    public Future<DescribeScalingActivitiesResult> describeScalingActivitiesAsync(AsyncHandler<DescribeScalingActivitiesRequest, DescribeScalingActivitiesResult> asyncHandler) {
        return this.describeScalingActivitiesAsync(new DescribeScalingActivitiesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeScalingProcessTypesResult> describeScalingProcessTypesAsync(DescribeScalingProcessTypesRequest request) {
        return this.describeScalingProcessTypesAsync(request, null);
    }

    @Override
    public Future<DescribeScalingProcessTypesResult> describeScalingProcessTypesAsync(final DescribeScalingProcessTypesRequest request, final AsyncHandler<DescribeScalingProcessTypesRequest, DescribeScalingProcessTypesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeScalingProcessTypesResult>(){

            @Override
            public DescribeScalingProcessTypesResult call() throws Exception {
                DescribeScalingProcessTypesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeScalingProcessTypes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeScalingProcessTypesResult> describeScalingProcessTypesAsync() {
        return this.describeScalingProcessTypesAsync(new DescribeScalingProcessTypesRequest());
    }

    @Override
    public Future<DescribeScalingProcessTypesResult> describeScalingProcessTypesAsync(AsyncHandler<DescribeScalingProcessTypesRequest, DescribeScalingProcessTypesResult> asyncHandler) {
        return this.describeScalingProcessTypesAsync(new DescribeScalingProcessTypesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeScheduledActionsResult> describeScheduledActionsAsync(DescribeScheduledActionsRequest request) {
        return this.describeScheduledActionsAsync(request, null);
    }

    @Override
    public Future<DescribeScheduledActionsResult> describeScheduledActionsAsync(final DescribeScheduledActionsRequest request, final AsyncHandler<DescribeScheduledActionsRequest, DescribeScheduledActionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeScheduledActionsResult>(){

            @Override
            public DescribeScheduledActionsResult call() throws Exception {
                DescribeScheduledActionsResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeScheduledActions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeScheduledActionsResult> describeScheduledActionsAsync() {
        return this.describeScheduledActionsAsync(new DescribeScheduledActionsRequest());
    }

    @Override
    public Future<DescribeScheduledActionsResult> describeScheduledActionsAsync(AsyncHandler<DescribeScheduledActionsRequest, DescribeScheduledActionsResult> asyncHandler) {
        return this.describeScheduledActionsAsync(new DescribeScheduledActionsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request) {
        return this.describeTagsAsync(request, null);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest request, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync() {
        return this.describeTagsAsync(new DescribeTagsRequest());
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) {
        return this.describeTagsAsync(new DescribeTagsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeTerminationPolicyTypesResult> describeTerminationPolicyTypesAsync(DescribeTerminationPolicyTypesRequest request) {
        return this.describeTerminationPolicyTypesAsync(request, null);
    }

    @Override
    public Future<DescribeTerminationPolicyTypesResult> describeTerminationPolicyTypesAsync(final DescribeTerminationPolicyTypesRequest request, final AsyncHandler<DescribeTerminationPolicyTypesRequest, DescribeTerminationPolicyTypesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeTerminationPolicyTypesResult>(){

            @Override
            public DescribeTerminationPolicyTypesResult call() throws Exception {
                DescribeTerminationPolicyTypesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.describeTerminationPolicyTypes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTerminationPolicyTypesResult> describeTerminationPolicyTypesAsync() {
        return this.describeTerminationPolicyTypesAsync(new DescribeTerminationPolicyTypesRequest());
    }

    @Override
    public Future<DescribeTerminationPolicyTypesResult> describeTerminationPolicyTypesAsync(AsyncHandler<DescribeTerminationPolicyTypesRequest, DescribeTerminationPolicyTypesResult> asyncHandler) {
        return this.describeTerminationPolicyTypesAsync(new DescribeTerminationPolicyTypesRequest(), asyncHandler);
    }

    @Override
    public Future<DetachInstancesResult> detachInstancesAsync(DetachInstancesRequest request) {
        return this.detachInstancesAsync(request, null);
    }

    @Override
    public Future<DetachInstancesResult> detachInstancesAsync(final DetachInstancesRequest request, final AsyncHandler<DetachInstancesRequest, DetachInstancesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DetachInstancesResult>(){

            @Override
            public DetachInstancesResult call() throws Exception {
                DetachInstancesResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.detachInstances(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetachLoadBalancersResult> detachLoadBalancersAsync(DetachLoadBalancersRequest request) {
        return this.detachLoadBalancersAsync(request, null);
    }

    @Override
    public Future<DetachLoadBalancersResult> detachLoadBalancersAsync(final DetachLoadBalancersRequest request, final AsyncHandler<DetachLoadBalancersRequest, DetachLoadBalancersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DetachLoadBalancersResult>(){

            @Override
            public DetachLoadBalancersResult call() throws Exception {
                DetachLoadBalancersResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.detachLoadBalancers(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetachLoadBalancersResult> detachLoadBalancersAsync() {
        return this.detachLoadBalancersAsync(new DetachLoadBalancersRequest());
    }

    @Override
    public Future<DetachLoadBalancersResult> detachLoadBalancersAsync(AsyncHandler<DetachLoadBalancersRequest, DetachLoadBalancersResult> asyncHandler) {
        return this.detachLoadBalancersAsync(new DetachLoadBalancersRequest(), asyncHandler);
    }

    @Override
    public Future<Void> disableMetricsCollectionAsync(DisableMetricsCollectionRequest request) {
        return this.disableMetricsCollectionAsync(request, null);
    }

    @Override
    public Future<Void> disableMetricsCollectionAsync(final DisableMetricsCollectionRequest request, final AsyncHandler<DisableMetricsCollectionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.disableMetricsCollection(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> enableMetricsCollectionAsync(EnableMetricsCollectionRequest request) {
        return this.enableMetricsCollectionAsync(request, null);
    }

    @Override
    public Future<Void> enableMetricsCollectionAsync(final EnableMetricsCollectionRequest request, final AsyncHandler<EnableMetricsCollectionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.enableMetricsCollection(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnterStandbyResult> enterStandbyAsync(EnterStandbyRequest request) {
        return this.enterStandbyAsync(request, null);
    }

    @Override
    public Future<EnterStandbyResult> enterStandbyAsync(final EnterStandbyRequest request, final AsyncHandler<EnterStandbyRequest, EnterStandbyResult> asyncHandler) {
        return this.executorService.submit(new Callable<EnterStandbyResult>(){

            @Override
            public EnterStandbyResult call() throws Exception {
                EnterStandbyResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.enterStandby(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> executePolicyAsync(ExecutePolicyRequest request) {
        return this.executePolicyAsync(request, null);
    }

    @Override
    public Future<Void> executePolicyAsync(final ExecutePolicyRequest request, final AsyncHandler<ExecutePolicyRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.executePolicy(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExitStandbyResult> exitStandbyAsync(ExitStandbyRequest request) {
        return this.exitStandbyAsync(request, null);
    }

    @Override
    public Future<ExitStandbyResult> exitStandbyAsync(final ExitStandbyRequest request, final AsyncHandler<ExitStandbyRequest, ExitStandbyResult> asyncHandler) {
        return this.executorService.submit(new Callable<ExitStandbyResult>(){

            @Override
            public ExitStandbyResult call() throws Exception {
                ExitStandbyResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.exitStandby(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutLifecycleHookResult> putLifecycleHookAsync(PutLifecycleHookRequest request) {
        return this.putLifecycleHookAsync(request, null);
    }

    @Override
    public Future<PutLifecycleHookResult> putLifecycleHookAsync(final PutLifecycleHookRequest request, final AsyncHandler<PutLifecycleHookRequest, PutLifecycleHookResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutLifecycleHookResult>(){

            @Override
            public PutLifecycleHookResult call() throws Exception {
                PutLifecycleHookResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.putLifecycleHook(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> putNotificationConfigurationAsync(PutNotificationConfigurationRequest request) {
        return this.putNotificationConfigurationAsync(request, null);
    }

    @Override
    public Future<Void> putNotificationConfigurationAsync(final PutNotificationConfigurationRequest request, final AsyncHandler<PutNotificationConfigurationRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.putNotificationConfiguration(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutScalingPolicyResult> putScalingPolicyAsync(PutScalingPolicyRequest request) {
        return this.putScalingPolicyAsync(request, null);
    }

    @Override
    public Future<PutScalingPolicyResult> putScalingPolicyAsync(final PutScalingPolicyRequest request, final AsyncHandler<PutScalingPolicyRequest, PutScalingPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutScalingPolicyResult>(){

            @Override
            public PutScalingPolicyResult call() throws Exception {
                PutScalingPolicyResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.putScalingPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> putScheduledUpdateGroupActionAsync(PutScheduledUpdateGroupActionRequest request) {
        return this.putScheduledUpdateGroupActionAsync(request, null);
    }

    @Override
    public Future<Void> putScheduledUpdateGroupActionAsync(final PutScheduledUpdateGroupActionRequest request, final AsyncHandler<PutScheduledUpdateGroupActionRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.putScheduledUpdateGroupAction(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RecordLifecycleActionHeartbeatResult> recordLifecycleActionHeartbeatAsync(RecordLifecycleActionHeartbeatRequest request) {
        return this.recordLifecycleActionHeartbeatAsync(request, null);
    }

    @Override
    public Future<RecordLifecycleActionHeartbeatResult> recordLifecycleActionHeartbeatAsync(final RecordLifecycleActionHeartbeatRequest request, final AsyncHandler<RecordLifecycleActionHeartbeatRequest, RecordLifecycleActionHeartbeatResult> asyncHandler) {
        return this.executorService.submit(new Callable<RecordLifecycleActionHeartbeatResult>(){

            @Override
            public RecordLifecycleActionHeartbeatResult call() throws Exception {
                RecordLifecycleActionHeartbeatResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.recordLifecycleActionHeartbeat(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> resumeProcessesAsync(ResumeProcessesRequest request) {
        return this.resumeProcessesAsync(request, null);
    }

    @Override
    public Future<Void> resumeProcessesAsync(final ResumeProcessesRequest request, final AsyncHandler<ResumeProcessesRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.resumeProcesses(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> setDesiredCapacityAsync(SetDesiredCapacityRequest request) {
        return this.setDesiredCapacityAsync(request, null);
    }

    @Override
    public Future<Void> setDesiredCapacityAsync(final SetDesiredCapacityRequest request, final AsyncHandler<SetDesiredCapacityRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.setDesiredCapacity(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> setInstanceHealthAsync(SetInstanceHealthRequest request) {
        return this.setInstanceHealthAsync(request, null);
    }

    @Override
    public Future<Void> setInstanceHealthAsync(final SetInstanceHealthRequest request, final AsyncHandler<SetInstanceHealthRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.setInstanceHealth(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetInstanceProtectionResult> setInstanceProtectionAsync(SetInstanceProtectionRequest request) {
        return this.setInstanceProtectionAsync(request, null);
    }

    @Override
    public Future<SetInstanceProtectionResult> setInstanceProtectionAsync(final SetInstanceProtectionRequest request, final AsyncHandler<SetInstanceProtectionRequest, SetInstanceProtectionResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetInstanceProtectionResult>(){

            @Override
            public SetInstanceProtectionResult call() throws Exception {
                SetInstanceProtectionResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.setInstanceProtection(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> suspendProcessesAsync(SuspendProcessesRequest request) {
        return this.suspendProcessesAsync(request, null);
    }

    @Override
    public Future<Void> suspendProcessesAsync(final SuspendProcessesRequest request, final AsyncHandler<SuspendProcessesRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.suspendProcesses(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TerminateInstanceInAutoScalingGroupResult> terminateInstanceInAutoScalingGroupAsync(TerminateInstanceInAutoScalingGroupRequest request) {
        return this.terminateInstanceInAutoScalingGroupAsync(request, null);
    }

    @Override
    public Future<TerminateInstanceInAutoScalingGroupResult> terminateInstanceInAutoScalingGroupAsync(final TerminateInstanceInAutoScalingGroupRequest request, final AsyncHandler<TerminateInstanceInAutoScalingGroupRequest, TerminateInstanceInAutoScalingGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<TerminateInstanceInAutoScalingGroupResult>(){

            @Override
            public TerminateInstanceInAutoScalingGroupResult call() throws Exception {
                TerminateInstanceInAutoScalingGroupResult result;
                try {
                    result = AmazonAutoScalingAsyncClient.this.terminateInstanceInAutoScalingGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> updateAutoScalingGroupAsync(UpdateAutoScalingGroupRequest request) {
        return this.updateAutoScalingGroupAsync(request, null);
    }

    @Override
    public Future<Void> updateAutoScalingGroupAsync(final UpdateAutoScalingGroupRequest request, final AsyncHandler<UpdateAutoScalingGroupRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonAutoScalingAsyncClient.this.updateAutoScalingGroup(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

