/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetAuthorizersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetAuthorizersRequestMarshaller
implements Marshaller<Request<GetAuthorizersRequest>, GetAuthorizersRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetAuthorizersRequest> marshall(GetAuthorizersRequest getAuthorizersRequest) {
        if (getAuthorizersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetAuthorizersRequest> request = new DefaultRequest<GetAuthorizersRequest>(getAuthorizersRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/authorizers";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getAuthorizersRequest.getRestApiId() != null ? StringUtils.fromString(getAuthorizersRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        if (getAuthorizersRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString(getAuthorizersRequest.getPosition()));
        }
        if (getAuthorizersRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger(getAuthorizersRequest.getLimit()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

