/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.DeleteAuthorizerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteAuthorizerRequestMarshaller
implements Marshaller<Request<DeleteAuthorizerRequest>, DeleteAuthorizerRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<DeleteAuthorizerRequest> marshall(DeleteAuthorizerRequest deleteAuthorizerRequest) {
        if (deleteAuthorizerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteAuthorizerRequest> request = new DefaultRequest<DeleteAuthorizerRequest>(deleteAuthorizerRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}/authorizers/{authorizer_id}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", deleteAuthorizerRequest.getRestApiId() != null ? StringUtils.fromString(deleteAuthorizerRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{authorizer_id}", deleteAuthorizerRequest.getAuthorizerId() != null ? StringUtils.fromString(deleteAuthorizerRequest.getAuthorizerId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

