/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGeneratedKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGeneratedTimestamp;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBVersionAttribute;
import java.lang.annotation.Annotation;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

@SdkInternalApi
final class DynamoDBAutoGeneratorRegistry {
    private static final DynamoDBAutoGeneratorRegistry INSTANCE = new DynamoDBAutoGeneratorRegistry();

    DynamoDBAutoGeneratorRegistry() {
    }

    static final DynamoDBAutoGeneratorRegistry instance() {
        return INSTANCE;
    }

    static final Generator<Object> generatorOf(Class<?> generatedType, Map<Class<? extends Annotation>, Annotation> annotations) {
        if (annotations.containsKey(DynamoDBAutoGeneratedKey.class)) {
            return DynamoDBAutoGeneratorRegistry.instance().keyGeneratorOf(generatedType);
        }
        if (annotations.containsKey(DynamoDBVersionAttribute.class)) {
            return DynamoDBAutoGeneratorRegistry.instance().versionGeneratorOf(generatedType);
        }
        if (annotations.containsKey(DynamoDBAutoGeneratedTimestamp.class)) {
            DynamoDBAutoGeneratedTimestamp annotation = (DynamoDBAutoGeneratedTimestamp)annotations.get(DynamoDBAutoGeneratedTimestamp.class);
            return DynamoDBAutoGeneratorRegistry.instance().timestampGeneratorOf(generatedType, annotation.strategy());
        }
        return DynamoDBAutoGeneratorRegistry.instance().neverGeneratorOf(generatedType);
    }

    final Generator<Object> neverGeneratorOf(Class<?> generatedType) {
        NeverGenerator<Object> result = new NeverGenerator<Object>(generatedType);
        return result;
    }

    final Generator<Object> keyGeneratorOf(Class<?> generatedType) {
        NeverKeyGenerator result = String.class.isAssignableFrom(generatedType) ? UuidStringKeyGenerator.INSTANCE : new NeverKeyGenerator(generatedType);
        return result;
    }

    final Generator<Object> versionGeneratorOf(Class<?> generatedType) {
        NeverVersionGenerator result = BigInteger.class.isAssignableFrom(generatedType) ? BigIntegerVersionGenerator.INSTANCE : (Byte.class.isAssignableFrom(generatedType) || Byte.TYPE.isAssignableFrom(generatedType) ? ByteVersionGenerator.INSTANCE : (Integer.class.isAssignableFrom(generatedType) || Integer.TYPE.isAssignableFrom(generatedType) ? IntegerVersionGenerator.INSTANCE : (Long.class.isAssignableFrom(generatedType) || Long.TYPE.isAssignableFrom(generatedType) ? LongVersionGenerator.INSTANCE : (Short.class.isAssignableFrom(generatedType) || Short.TYPE.isAssignableFrom(generatedType) ? ShortVersionGenerator.INSTANCE : new NeverVersionGenerator(generatedType)))));
        return result;
    }

    final Generator<Object> timestampGeneratorOf(Class<?> generatedType, DynamoDBAutoGenerateStrategy strategy) {
        NeverTimestampGenerator result = Calendar.class.isAssignableFrom(generatedType) ? new CalendarTimestampGenerator(strategy) : (Date.class.isAssignableFrom(generatedType) ? new DateTimestampGenerator(strategy) : (Long.class.isAssignableFrom(generatedType) ? new LongTimestampGenerator(strategy) : new NeverTimestampGenerator(generatedType, strategy)));
        return result;
    }

    static final class LongTimestampGenerator
    extends NeverTimestampGenerator<Long> {
        private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

        public LongTimestampGenerator(DynamoDBAutoGenerateStrategy strategy) {
            super(Long.class, strategy);
        }

        @Override
        public final Long generate(Long currentValue) {
            return Calendar.getInstance(UTC).getTime().getTime();
        }
    }

    static final class DateTimestampGenerator
    extends NeverTimestampGenerator<Date> {
        public DateTimestampGenerator(DynamoDBAutoGenerateStrategy strategy) {
            super(Date.class, strategy);
        }

        @Override
        public final Date generate(Date currentValue) {
            return Calendar.getInstance().getTime();
        }
    }

    static final class CalendarTimestampGenerator
    extends NeverTimestampGenerator<Calendar> {
        public CalendarTimestampGenerator(DynamoDBAutoGenerateStrategy strategy) {
            super(Calendar.class, strategy);
        }

        @Override
        public final Calendar generate(Calendar currentValue) {
            return Calendar.getInstance();
        }
    }

    static class NeverTimestampGenerator<T>
    extends AbstractGenerator<T> {
        public NeverTimestampGenerator(Class<T> generatedType, DynamoDBAutoGenerateStrategy strategy) {
            super(generatedType, strategy);
        }

        @Override
        public T generate(T currentValue) {
            throw new DynamoDBMappingException("Unsupported type for @DynamoDBAutoGeneratedTimestamp; only Calendar, Date, or Long allowed");
        }
    }

    static final class ShortVersionGenerator
    extends NeverVersionGenerator<Short> {
        private static final ShortVersionGenerator INSTANCE = new ShortVersionGenerator();

        public ShortVersionGenerator() {
            super(Short.class);
        }

        @Override
        public final Short generate(Short currentValue) {
            if (currentValue == null) {
                return (short)1;
            }
            return (short)(currentValue + 1);
        }
    }

    static final class LongVersionGenerator
    extends NeverVersionGenerator<Long> {
        private static final LongVersionGenerator INSTANCE = new LongVersionGenerator();

        public LongVersionGenerator() {
            super(Long.class);
        }

        @Override
        public final Long generate(Long currentValue) {
            if (currentValue == null) {
                return 1L;
            }
            return currentValue + 1L;
        }
    }

    static final class IntegerVersionGenerator
    extends NeverVersionGenerator<Integer> {
        private static final IntegerVersionGenerator INSTANCE = new IntegerVersionGenerator();

        public IntegerVersionGenerator() {
            super(Integer.class);
        }

        @Override
        public final Integer generate(Integer currentValue) {
            if (currentValue == null) {
                return 1;
            }
            return currentValue + 1;
        }
    }

    static final class ByteVersionGenerator
    extends NeverVersionGenerator<Byte> {
        private static final ByteVersionGenerator INSTANCE = new ByteVersionGenerator();

        public ByteVersionGenerator() {
            super(Byte.class);
        }

        @Override
        public final Byte generate(Byte currentValue) {
            if (currentValue == null) {
                return (byte)1;
            }
            return (byte)((currentValue + 1) % 127);
        }
    }

    static final class BigIntegerVersionGenerator
    extends NeverVersionGenerator<BigInteger> {
        private static final BigIntegerVersionGenerator INSTANCE = new BigIntegerVersionGenerator();

        public BigIntegerVersionGenerator() {
            super(BigInteger.class);
        }

        @Override
        public final BigInteger generate(BigInteger currentValue) {
            if (currentValue == null) {
                return BigInteger.ONE;
            }
            return currentValue.add(BigInteger.ONE);
        }
    }

    static class NeverVersionGenerator<T>
    extends AbstractGenerator<T> {
        public NeverVersionGenerator(Class<T> generatedType) {
            super(generatedType, AlwaysGeneratable.instance());
        }

        @Override
        public T generate(T currentValue) {
            throw new DynamoDBMappingException("Unsupported type for @DynamoDBVersionAttribute; only BigInteger, Byte, Integer or Long allowed");
        }
    }

    static final class UuidStringKeyGenerator
    extends NeverKeyGenerator<String> {
        private static final UuidStringKeyGenerator INSTANCE = new UuidStringKeyGenerator();

        public UuidStringKeyGenerator() {
            super(String.class);
        }

        @Override
        public final String generate(String currentValue) {
            return UUID.randomUUID().toString();
        }
    }

    static class NeverKeyGenerator<T>
    extends AbstractGenerator<T> {
        public NeverKeyGenerator(Class<T> generatedType) {
            super(generatedType, CreateGeneratable.instance());
        }

        @Override
        public T generate(T currentValue) {
            throw new DynamoDBMappingException("Unsupported type for @DynamoDBAutoGeneratedKey; only String allowed");
        }
    }

    static class NeverGenerator<T>
    extends AbstractGenerator<T> {
        public NeverGenerator(Class<T> generatedType) {
            super(generatedType, NeverGeneratable.instance());
        }
    }

    static abstract class AbstractGenerator<T>
    implements Generator<T> {
        private final Class<T> generatedType;
        private final Generatable<T> generatable;

        public AbstractGenerator(Class<T> generatedType, Generatable<T> generatable) {
            this.generatedType = generatedType;
            this.generatable = generatable;
        }

        public AbstractGenerator(Class<T> generatedType, DynamoDBAutoGenerateStrategy strategy) {
            this(generatedType, DynamoDBAutoGenerateStrategy.CREATE == strategy ? CreateGeneratable.instance() : AlwaysGeneratable.instance());
        }

        private final Class<T> getGeneratedType() {
            return this.generatedType;
        }

        private final Generatable<T> getGeneratable() {
            return this.generatable;
        }

        @Override
        public boolean canGenerate(T currentValue) {
            return this.getGeneratable().canGenerate(currentValue);
        }

        @Override
        public T generate(T currentValue) {
            throw new DynamoDBMappingException("Generate not supported for " + this.getGeneratedType());
        }
    }

    static interface Generator<T>
    extends Generatable<T> {
        public T generate(T var1);
    }

    static final class CreateGeneratable<T>
    implements Generatable<T> {
        private static final CreateGeneratable<Object> INSTANCE = new CreateGeneratable();

        CreateGeneratable() {
        }

        private static final <T> CreateGeneratable<T> instance() {
            return INSTANCE;
        }

        @Override
        public final boolean canGenerate(T currentValue) {
            return currentValue == null;
        }
    }

    static final class AlwaysGeneratable<T>
    implements Generatable<T> {
        private static final AlwaysGeneratable<Object> INSTANCE = new AlwaysGeneratable();

        AlwaysGeneratable() {
        }

        private static final <T> AlwaysGeneratable<T> instance() {
            return INSTANCE;
        }

        @Override
        public final boolean canGenerate(T currentValue) {
            return true;
        }
    }

    static final class NeverGeneratable<T>
    implements Generatable<T> {
        private static final NeverGeneratable<Object> INSTANCE = new NeverGeneratable();

        NeverGeneratable() {
        }

        private static final <T> NeverGeneratable<T> instance() {
            return INSTANCE;
        }

        @Override
        public final boolean canGenerate(T currentValue) {
            return false;
        }
    }

    static interface Generatable<T> {
        public boolean canGenerate(T var1);
    }
}

