/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codedeploy.model.GetApplicationRevisionRequest;
import com.amazonaws.services.codedeploy.model.transform.RevisionLocationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class GetApplicationRevisionRequestMarshaller
implements Marshaller<Request<GetApplicationRevisionRequest>, GetApplicationRevisionRequest> {
    @Override
    public Request<GetApplicationRevisionRequest> marshall(GetApplicationRevisionRequest getApplicationRevisionRequest) {
        if (getApplicationRevisionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetApplicationRevisionRequest> request = new DefaultRequest<GetApplicationRevisionRequest>(getApplicationRevisionRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.GetApplicationRevision");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (getApplicationRevisionRequest.getApplicationName() != null) {
                jsonWriter.key("applicationName").value(getApplicationRevisionRequest.getApplicationName());
            }
            if (getApplicationRevisionRequest.getRevision() != null) {
                jsonWriter.key("revision");
                RevisionLocationJsonMarshaller.getInstance().marshall(getApplicationRevisionRequest.getRevision(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

