/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codecommit.model.RepositoryTrigger;
import com.amazonaws.services.codecommit.model.TestRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.transform.RepositoryTriggerJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class TestRepositoryTriggersRequestMarshaller
implements Marshaller<Request<TestRepositoryTriggersRequest>, TestRepositoryTriggersRequest> {
    @Override
    public Request<TestRepositoryTriggersRequest> marshall(TestRepositoryTriggersRequest testRepositoryTriggersRequest) {
        if (testRepositoryTriggersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TestRepositoryTriggersRequest> request = new DefaultRequest<TestRepositoryTriggersRequest>(testRepositoryTriggersRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.TestRepositoryTriggers");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<RepositoryTrigger> triggersList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (testRepositoryTriggersRequest.getRepositoryName() != null) {
                jsonWriter.key("repositoryName").value(testRepositoryTriggersRequest.getRepositoryName());
            }
            if ((triggersList = testRepositoryTriggersRequest.getTriggers()) != null) {
                jsonWriter.key("triggers");
                jsonWriter.array();
                for (RepositoryTrigger triggersListValue : triggersList) {
                    if (triggersListValue == null) continue;
                    RepositoryTriggerJsonMarshaller.getInstance().marshall(triggersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

