/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.waf.model.SampledHTTPRequest;
import com.amazonaws.services.waf.model.transform.HTTPRequestJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class SampledHTTPRequestJsonMarshaller {
    private static SampledHTTPRequestJsonMarshaller instance;

    public void marshall(SampledHTTPRequest sampledHTTPRequest, JSONWriter jsonWriter) {
        if (sampledHTTPRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (sampledHTTPRequest.getRequest() != null) {
                jsonWriter.key("Request");
                HTTPRequestJsonMarshaller.getInstance().marshall(sampledHTTPRequest.getRequest(), jsonWriter);
            }
            if (sampledHTTPRequest.getWeight() != null) {
                jsonWriter.key("Weight").value(sampledHTTPRequest.getWeight());
            }
            if (sampledHTTPRequest.getTimestamp() != null) {
                jsonWriter.key("Timestamp").value(sampledHTTPRequest.getTimestamp());
            }
            if (sampledHTTPRequest.getAction() != null) {
                jsonWriter.key("Action").value(sampledHTTPRequest.getAction());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SampledHTTPRequestJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SampledHTTPRequestJsonMarshaller();
        }
        return instance;
    }
}

