/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.datapipeline.model.Field;
import com.amazonaws.util.json.JSONWriter;

public class FieldJsonMarshaller {
    private static FieldJsonMarshaller instance;

    public void marshall(Field field, JSONWriter jsonWriter) {
        if (field == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (field.getKey() != null) {
                jsonWriter.key("key").value(field.getKey());
            }
            if (field.getStringValue() != null) {
                jsonWriter.key("stringValue").value(field.getStringValue());
            }
            if (field.getRefValue() != null) {
                jsonWriter.key("refValue").value(field.getRefValue());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FieldJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FieldJsonMarshaller();
        }
        return instance;
    }
}

