/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetAuthorizersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetAuthorizersRequestMarshaller
implements Marshaller<Request<GetAuthorizersRequest>, GetAuthorizersRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetAuthorizersRequest> marshall(GetAuthorizersRequest getAuthorizersRequest) {
        String limit;
        String position;
        if (getAuthorizersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetAuthorizersRequest> request = new DefaultRequest<GetAuthorizersRequest>(getAuthorizersRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/authorizers";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getAuthorizersRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(getAuthorizersRequest.getRestApiId()));
        request.setResourcePath(uriResourcePath);
        String string = position = getAuthorizersRequest.getPosition() == null ? null : StringUtils.fromString(getAuthorizersRequest.getPosition());
        if (position != null) {
            request.addParameter("position", position);
        }
        String string2 = limit = getAuthorizersRequest.getLimit() == null ? null : StringUtils.fromInteger(getAuthorizersRequest.getLimit());
        if (limit != null) {
            request.addParameter("limit", limit);
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

