/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.CommandInvocation;
import com.amazonaws.services.simplesystemsmanagement.model.CommandPlugin;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CommandPluginJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class CommandInvocationJsonMarshaller {
    private static CommandInvocationJsonMarshaller instance;

    public void marshall(CommandInvocation commandInvocation, JSONWriter jsonWriter) {
        if (commandInvocation == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList commandPluginsList;
            jsonWriter.object();
            if (commandInvocation.getCommandId() != null) {
                jsonWriter.key("CommandId").value(commandInvocation.getCommandId());
            }
            if (commandInvocation.getInstanceId() != null) {
                jsonWriter.key("InstanceId").value(commandInvocation.getInstanceId());
            }
            if (commandInvocation.getComment() != null) {
                jsonWriter.key("Comment").value(commandInvocation.getComment());
            }
            if (commandInvocation.getDocumentName() != null) {
                jsonWriter.key("DocumentName").value(commandInvocation.getDocumentName());
            }
            if (commandInvocation.getRequestedDateTime() != null) {
                jsonWriter.key("RequestedDateTime").value(commandInvocation.getRequestedDateTime());
            }
            if (commandInvocation.getStatus() != null) {
                jsonWriter.key("Status").value(commandInvocation.getStatus());
            }
            if (commandInvocation.getTraceOutput() != null) {
                jsonWriter.key("TraceOutput").value(commandInvocation.getTraceOutput());
            }
            if (!(commandPluginsList = (SdkInternalList)commandInvocation.getCommandPlugins()).isEmpty() || !commandPluginsList.isAutoConstruct()) {
                jsonWriter.key("CommandPlugins");
                jsonWriter.array();
                for (CommandPlugin commandPluginsListValue : commandPluginsList) {
                    if (commandPluginsListValue == null) continue;
                    CommandPluginJsonMarshaller.getInstance().marshall(commandPluginsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CommandInvocationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CommandInvocationJsonMarshaller();
        }
        return instance;
    }
}

