/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.PlatformType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DocumentIdentifier
implements Serializable,
Cloneable {
    private String name;
    private SdkInternalList<String> platformTypes;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DocumentIdentifier withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getPlatformTypes() {
        if (this.platformTypes == null) {
            this.platformTypes = new SdkInternalList();
        }
        return this.platformTypes;
    }

    public void setPlatformTypes(Collection<String> platformTypes) {
        if (platformTypes == null) {
            this.platformTypes = null;
            return;
        }
        this.platformTypes = new SdkInternalList<String>(platformTypes);
    }

    public DocumentIdentifier withPlatformTypes(String ... platformTypes) {
        if (this.platformTypes == null) {
            this.setPlatformTypes(new SdkInternalList<String>(platformTypes.length));
        }
        for (String ele : platformTypes) {
            this.platformTypes.add(ele);
        }
        return this;
    }

    public DocumentIdentifier withPlatformTypes(Collection<String> platformTypes) {
        this.setPlatformTypes(platformTypes);
        return this;
    }

    public DocumentIdentifier withPlatformTypes(PlatformType ... platformTypes) {
        SdkInternalList<String> platformTypesCopy = new SdkInternalList<String>(platformTypes.length);
        for (PlatformType value : platformTypes) {
            platformTypesCopy.add(value.toString());
        }
        if (this.getPlatformTypes() == null) {
            this.setPlatformTypes(platformTypesCopy);
        } else {
            this.getPlatformTypes().addAll(platformTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getPlatformTypes() != null) {
            sb.append("PlatformTypes: " + this.getPlatformTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentIdentifier)) {
            return false;
        }
        DocumentIdentifier other = (DocumentIdentifier)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPlatformTypes() == null ^ this.getPlatformTypes() == null) {
            return false;
        }
        return other.getPlatformTypes() == null || other.getPlatformTypes().equals(this.getPlatformTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformTypes() == null ? 0 : this.getPlatformTypes().hashCode());
        return hashCode;
    }

    public DocumentIdentifier clone() {
        try {
            return (DocumentIdentifier)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

