/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class DestinationStaxUnmarshaller
implements Unmarshaller<Destination, StaxUnmarshallerContext> {
    private static DestinationStaxUnmarshaller instance;

    @Override
    public Destination unmarshall(StaxUnmarshallerContext context) throws Exception {
        Destination destination = new Destination();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return destination;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ToAddresses/member", targetDepth)) {
                    destination.getToAddresses().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CcAddresses/member", targetDepth)) {
                    destination.getCcAddresses().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("BccAddresses/member", targetDepth)) continue;
                destination.getBccAddresses().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return destination;
    }

    public static DestinationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DestinationStaxUnmarshaller();
        }
        return instance;
    }
}

