/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListHealthChecksRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListHealthChecksRequestMarshaller
implements Marshaller<Request<ListHealthChecksRequest>, ListHealthChecksRequest> {
    @Override
    public Request<ListHealthChecksRequest> marshall(ListHealthChecksRequest listHealthChecksRequest) {
        String maxItems;
        String marker;
        if (listHealthChecksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListHealthChecksRequest> request = new DefaultRequest<ListHealthChecksRequest>(listHealthChecksRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/healthcheck";
        request.setResourcePath(uriResourcePath);
        String string = marker = listHealthChecksRequest.getMarker() == null ? null : StringUtils.fromString(listHealthChecksRequest.getMarker());
        if (marker != null) {
            request.addParameter("marker", marker);
        }
        String string2 = maxItems = listHealthChecksRequest.getMaxItems() == null ? null : StringUtils.fromString(listHealthChecksRequest.getMaxItems());
        if (maxItems != null) {
            request.addParameter("maxitems", maxItems);
        }
        return request;
    }
}

