/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.opsworks.model.ChefConfiguration;
import com.amazonaws.util.json.JSONWriter;

public class ChefConfigurationJsonMarshaller {
    private static ChefConfigurationJsonMarshaller instance;

    public void marshall(ChefConfiguration chefConfiguration, JSONWriter jsonWriter) {
        if (chefConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (chefConfiguration.getManageBerkshelf() != null) {
                jsonWriter.key("ManageBerkshelf").value(chefConfiguration.getManageBerkshelf());
            }
            if (chefConfiguration.getBerkshelfVersion() != null) {
                jsonWriter.key("BerkshelfVersion").value(chefConfiguration.getBerkshelfVersion());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ChefConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ChefConfigurationJsonMarshaller();
        }
        return instance;
    }
}

