/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.lambda.model.EC2UnexpectedException;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.util.json.JSONObject;

public class EC2UnexpectedExceptionUnmarshaller
extends JsonErrorUnmarshaller {
    public EC2UnexpectedExceptionUnmarshaller() {
        super(EC2UnexpectedException.class);
    }

    @Override
    public boolean match(String errorTypeFromHeader, JSONObject json) throws Exception {
        if (errorTypeFromHeader == null) {
            String errorCodeFromContent = this.parseErrorCode(json);
            return errorCodeFromContent != null && errorCodeFromContent.equals("EC2UnexpectedException");
        }
        return errorTypeFromHeader.equals("EC2UnexpectedException");
    }

    @Override
    public AmazonServiceException unmarshall(JSONObject json) throws Exception {
        EC2UnexpectedException e = (EC2UnexpectedException)super.unmarshall(json);
        e.setErrorCode("EC2UnexpectedException");
        e.setType(this.parseMember("Type", json));
        e.setEC2ErrorCode(this.parseMember("EC2ErrorCode", json));
        return e;
    }
}

