/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.DestinationDescription;
import com.amazonaws.services.kinesisfirehose.model.transform.RedshiftDestinationDescriptionJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.S3DestinationDescriptionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class DestinationDescriptionJsonMarshaller {
    private static DestinationDescriptionJsonMarshaller instance;

    public void marshall(DestinationDescription destinationDescription, JSONWriter jsonWriter) {
        if (destinationDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (destinationDescription.getDestinationId() != null) {
                jsonWriter.key("DestinationId").value(destinationDescription.getDestinationId());
            }
            if (destinationDescription.getS3DestinationDescription() != null) {
                jsonWriter.key("S3DestinationDescription");
                S3DestinationDescriptionJsonMarshaller.getInstance().marshall(destinationDescription.getS3DestinationDescription(), jsonWriter);
            }
            if (destinationDescription.getRedshiftDestinationDescription() != null) {
                jsonWriter.key("RedshiftDestinationDescription");
                RedshiftDestinationDescriptionJsonMarshaller.getInstance().marshall(destinationDescription.getRedshiftDestinationDescription(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DestinationDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DestinationDescriptionJsonMarshaller();
        }
        return instance;
    }
}

