/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.transform.HashKeyRangeJsonMarshaller;
import com.amazonaws.services.kinesis.model.transform.SequenceNumberRangeJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ShardJsonMarshaller {
    private static ShardJsonMarshaller instance;

    public void marshall(Shard shard, JSONWriter jsonWriter) {
        if (shard == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (shard.getShardId() != null) {
                jsonWriter.key("ShardId").value(shard.getShardId());
            }
            if (shard.getParentShardId() != null) {
                jsonWriter.key("ParentShardId").value(shard.getParentShardId());
            }
            if (shard.getAdjacentParentShardId() != null) {
                jsonWriter.key("AdjacentParentShardId").value(shard.getAdjacentParentShardId());
            }
            if (shard.getHashKeyRange() != null) {
                jsonWriter.key("HashKeyRange");
                HashKeyRangeJsonMarshaller.getInstance().marshall(shard.getHashKeyRange(), jsonWriter);
            }
            if (shard.getSequenceNumberRange() != null) {
                jsonWriter.key("SequenceNumberRange");
                SequenceNumberRangeJsonMarshaller.getInstance().marshall(shard.getSequenceNumberRange(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ShardJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ShardJsonMarshaller();
        }
        return instance;
    }
}

