/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.ListBuildsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListBuildsRequestMarshaller
implements Marshaller<Request<ListBuildsRequest>, ListBuildsRequest> {
    @Override
    public Request<ListBuildsRequest> marshall(ListBuildsRequest listBuildsRequest) {
        if (listBuildsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListBuildsRequest> request = new DefaultRequest<ListBuildsRequest>(listBuildsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.ListBuilds");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listBuildsRequest.getStatus() != null) {
                jsonWriter.key("Status").value(listBuildsRequest.getStatus());
            }
            if (listBuildsRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(listBuildsRequest.getLimit());
            }
            if (listBuildsRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(listBuildsRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

