/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.gamelift.model.GameProperty;
import com.amazonaws.services.gamelift.model.GameSession;
import com.amazonaws.services.gamelift.model.transform.GamePropertyJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class GameSessionJsonMarshaller {
    private static GameSessionJsonMarshaller instance;

    public void marshall(GameSession gameSession, JSONWriter jsonWriter) {
        if (gameSession == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<GameProperty> gamePropertiesList;
            jsonWriter.object();
            if (gameSession.getGameSessionId() != null) {
                jsonWriter.key("GameSessionId").value(gameSession.getGameSessionId());
            }
            if (gameSession.getName() != null) {
                jsonWriter.key("Name").value(gameSession.getName());
            }
            if (gameSession.getFleetId() != null) {
                jsonWriter.key("FleetId").value(gameSession.getFleetId());
            }
            if (gameSession.getCreationTime() != null) {
                jsonWriter.key("CreationTime").value(gameSession.getCreationTime());
            }
            if (gameSession.getTerminationTime() != null) {
                jsonWriter.key("TerminationTime").value(gameSession.getTerminationTime());
            }
            if (gameSession.getCurrentPlayerSessionCount() != null) {
                jsonWriter.key("CurrentPlayerSessionCount").value(gameSession.getCurrentPlayerSessionCount());
            }
            if (gameSession.getMaximumPlayerSessionCount() != null) {
                jsonWriter.key("MaximumPlayerSessionCount").value(gameSession.getMaximumPlayerSessionCount());
            }
            if (gameSession.getStatus() != null) {
                jsonWriter.key("Status").value(gameSession.getStatus());
            }
            if ((gamePropertiesList = gameSession.getGameProperties()) != null) {
                jsonWriter.key("GameProperties");
                jsonWriter.array();
                for (GameProperty gamePropertiesListValue : gamePropertiesList) {
                    if (gamePropertiesListValue == null) continue;
                    GamePropertyJsonMarshaller.getInstance().marshall(gamePropertiesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (gameSession.getIpAddress() != null) {
                jsonWriter.key("IpAddress").value(gameSession.getIpAddress());
            }
            if (gameSession.getPlayerSessionCreationPolicy() != null) {
                jsonWriter.key("PlayerSessionCreationPolicy").value(gameSession.getPlayerSessionCreationPolicy());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GameSessionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GameSessionJsonMarshaller();
        }
        return instance;
    }
}

