/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.gamelift.model.Credentials;
import com.amazonaws.util.json.JSONWriter;

public class CredentialsJsonMarshaller {
    private static CredentialsJsonMarshaller instance;

    public void marshall(Credentials credentials, JSONWriter jsonWriter) {
        if (credentials == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (credentials.getAccessKeyId() != null) {
                jsonWriter.key("AccessKeyId").value(credentials.getAccessKeyId());
            }
            if (credentials.getSecretAccessKey() != null) {
                jsonWriter.key("SecretAccessKey").value(credentials.getSecretAccessKey());
            }
            if (credentials.getSessionToken() != null) {
                jsonWriter.key("SessionToken").value(credentials.getSessionToken());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CredentialsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CredentialsJsonMarshaller();
        }
        return instance;
    }
}

