/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.CreatePlayerSessionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreatePlayerSessionRequestMarshaller
implements Marshaller<Request<CreatePlayerSessionRequest>, CreatePlayerSessionRequest> {
    @Override
    public Request<CreatePlayerSessionRequest> marshall(CreatePlayerSessionRequest createPlayerSessionRequest) {
        if (createPlayerSessionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePlayerSessionRequest> request = new DefaultRequest<CreatePlayerSessionRequest>(createPlayerSessionRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.CreatePlayerSession");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createPlayerSessionRequest.getGameSessionId() != null) {
                jsonWriter.key("GameSessionId").value(createPlayerSessionRequest.getGameSessionId());
            }
            if (createPlayerSessionRequest.getPlayerId() != null) {
                jsonWriter.key("PlayerId").value(createPlayerSessionRequest.getPlayerId());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

