/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.CreateBuildRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateBuildRequestMarshaller
implements Marshaller<Request<CreateBuildRequest>, CreateBuildRequest> {
    @Override
    public Request<CreateBuildRequest> marshall(CreateBuildRequest createBuildRequest) {
        if (createBuildRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateBuildRequest> request = new DefaultRequest<CreateBuildRequest>(createBuildRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.CreateBuild");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createBuildRequest.getName() != null) {
                jsonWriter.key("Name").value(createBuildRequest.getName());
            }
            if (createBuildRequest.getVersion() != null) {
                jsonWriter.key("Version").value(createBuildRequest.getVersion());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

