/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codedeploy.model.RevisionInfo;
import com.amazonaws.services.codedeploy.model.transform.GenericRevisionInfoJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.RevisionLocationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class RevisionInfoJsonMarshaller {
    private static RevisionInfoJsonMarshaller instance;

    public void marshall(RevisionInfo revisionInfo, JSONWriter jsonWriter) {
        if (revisionInfo == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (revisionInfo.getRevisionLocation() != null) {
                jsonWriter.key("revisionLocation");
                RevisionLocationJsonMarshaller.getInstance().marshall(revisionInfo.getRevisionLocation(), jsonWriter);
            }
            if (revisionInfo.getGenericRevisionInfo() != null) {
                jsonWriter.key("genericRevisionInfo");
                GenericRevisionInfoJsonMarshaller.getInstance().marshall(revisionInfo.getGenericRevisionInfo(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RevisionInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RevisionInfoJsonMarshaller();
        }
        return instance;
    }
}

