/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.DeleteDeploymentRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteDeploymentRequestMarshaller
implements Marshaller<Request<DeleteDeploymentRequest>, DeleteDeploymentRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<DeleteDeploymentRequest> marshall(DeleteDeploymentRequest deleteDeploymentRequest) {
        if (deleteDeploymentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteDeploymentRequest> request = new DefaultRequest<DeleteDeploymentRequest>(deleteDeploymentRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}/deployments/{deployment_id}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", deleteDeploymentRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(deleteDeploymentRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{deployment_id}", deleteDeploymentRequest.getDeploymentId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(deleteDeploymentRequest.getDeploymentId()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

