/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.CreateAuthorizerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateAuthorizerRequestMarshaller
implements Marshaller<Request<CreateAuthorizerRequest>, CreateAuthorizerRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<CreateAuthorizerRequest> marshall(CreateAuthorizerRequest createAuthorizerRequest) {
        if (createAuthorizerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateAuthorizerRequest> request = new DefaultRequest<CreateAuthorizerRequest>(createAuthorizerRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/authorizers";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", createAuthorizerRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(createAuthorizerRequest.getRestApiId()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createAuthorizerRequest.getName() != null) {
                jsonWriter.key("name").value(createAuthorizerRequest.getName());
            }
            if (createAuthorizerRequest.getType() != null) {
                jsonWriter.key("type").value(createAuthorizerRequest.getType());
            }
            if (createAuthorizerRequest.getAuthorizerUri() != null) {
                jsonWriter.key("authorizerUri").value(createAuthorizerRequest.getAuthorizerUri());
            }
            if (createAuthorizerRequest.getAuthorizerCredentials() != null) {
                jsonWriter.key("authorizerCredentials").value(createAuthorizerRequest.getAuthorizerCredentials());
            }
            if (createAuthorizerRequest.getIdentitySource() != null) {
                jsonWriter.key("identitySource").value(createAuthorizerRequest.getIdentitySource());
            }
            if (createAuthorizerRequest.getIdentityValidationExpression() != null) {
                jsonWriter.key("identityValidationExpression").value(createAuthorizerRequest.getIdentityValidationExpression());
            }
            if (createAuthorizerRequest.getAuthorizerResultTtlInSeconds() != null) {
                jsonWriter.key("authorizerResultTtlInSeconds").value(createAuthorizerRequest.getAuthorizerResultTtlInSeconds());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

