/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.CreateResourceGroupRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateResourceGroupRequestMarshaller
implements Marshaller<Request<CreateResourceGroupRequest>, CreateResourceGroupRequest> {
    @Override
    public Request<CreateResourceGroupRequest> marshall(CreateResourceGroupRequest createResourceGroupRequest) {
        if (createResourceGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateResourceGroupRequest> request = new DefaultRequest<CreateResourceGroupRequest>(createResourceGroupRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.CreateResourceGroup");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createResourceGroupRequest.getResourceGroupTags() != null) {
                jsonWriter.key("resourceGroupTags").value(createResourceGroupRequest.getResourceGroupTags());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

