/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.BatchGetApplicationRevisionsRequest;
import com.amazonaws.services.codedeploy.model.RevisionLocation;
import com.amazonaws.services.codedeploy.model.transform.RevisionLocationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class BatchGetApplicationRevisionsRequestMarshaller
implements Marshaller<Request<BatchGetApplicationRevisionsRequest>, BatchGetApplicationRevisionsRequest> {
    @Override
    public Request<BatchGetApplicationRevisionsRequest> marshall(BatchGetApplicationRevisionsRequest batchGetApplicationRevisionsRequest) {
        if (batchGetApplicationRevisionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchGetApplicationRevisionsRequest> request = new DefaultRequest<BatchGetApplicationRevisionsRequest>(batchGetApplicationRevisionsRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.BatchGetApplicationRevisions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList revisionsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (batchGetApplicationRevisionsRequest.getApplicationName() != null) {
                jsonWriter.key("applicationName").value(batchGetApplicationRevisionsRequest.getApplicationName());
            }
            if (!(revisionsList = (SdkInternalList)batchGetApplicationRevisionsRequest.getRevisions()).isEmpty() || !revisionsList.isAutoConstruct()) {
                jsonWriter.key("revisions");
                jsonWriter.array();
                for (RevisionLocation revisionsListValue : revisionsList) {
                    if (revisionsListValue == null) continue;
                    RevisionLocationJsonMarshaller.getInstance().marshall(revisionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

