/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.DescribeGameSessionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeGameSessionsRequestMarshaller
implements Marshaller<Request<DescribeGameSessionsRequest>, DescribeGameSessionsRequest> {
    @Override
    public Request<DescribeGameSessionsRequest> marshall(DescribeGameSessionsRequest describeGameSessionsRequest) {
        if (describeGameSessionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeGameSessionsRequest> request = new DefaultRequest<DescribeGameSessionsRequest>(describeGameSessionsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.DescribeGameSessions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeGameSessionsRequest.getFleetId() != null) {
                jsonWriter.key("FleetId").value(describeGameSessionsRequest.getFleetId());
            }
            if (describeGameSessionsRequest.getGameSessionId() != null) {
                jsonWriter.key("GameSessionId").value(describeGameSessionsRequest.getGameSessionId());
            }
            if (describeGameSessionsRequest.getAliasId() != null) {
                jsonWriter.key("AliasId").value(describeGameSessionsRequest.getAliasId());
            }
            if (describeGameSessionsRequest.getStatusFilter() != null) {
                jsonWriter.key("StatusFilter").value(describeGameSessionsRequest.getStatusFilter());
            }
            if (describeGameSessionsRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(describeGameSessionsRequest.getLimit());
            }
            if (describeGameSessionsRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(describeGameSessionsRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

