/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.elastictranscoder.model.CreateJobOutput;
import com.amazonaws.services.elastictranscoder.model.CreateJobPlaylist;
import com.amazonaws.services.elastictranscoder.model.CreateJobRequest;
import com.amazonaws.services.elastictranscoder.model.transform.CreateJobOutputJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreateJobPlaylistJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.JobInputJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

public class CreateJobRequestMarshaller
implements Marshaller<Request<CreateJobRequest>, CreateJobRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<CreateJobRequest> marshall(CreateJobRequest createJobRequest) {
        if (createJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateJobRequest> request = new DefaultRequest<CreateJobRequest>(createJobRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2012-09-25/jobs";
        request.setResourcePath(uriResourcePath);
        try {
            SdkInternalMap userMetadataMap;
            SdkInternalList playlistsList;
            SdkInternalList outputsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createJobRequest.getPipelineId() != null) {
                jsonWriter.key("PipelineId").value(createJobRequest.getPipelineId());
            }
            if (createJobRequest.getInput() != null) {
                jsonWriter.key("Input");
                JobInputJsonMarshaller.getInstance().marshall(createJobRequest.getInput(), jsonWriter);
            }
            if (createJobRequest.getOutput() != null) {
                jsonWriter.key("Output");
                CreateJobOutputJsonMarshaller.getInstance().marshall(createJobRequest.getOutput(), jsonWriter);
            }
            if (!(outputsList = (SdkInternalList)createJobRequest.getOutputs()).isEmpty() || !outputsList.isAutoConstruct()) {
                jsonWriter.key("Outputs");
                jsonWriter.array();
                for (CreateJobOutput outputsListValue : outputsList) {
                    if (outputsListValue == null) continue;
                    CreateJobOutputJsonMarshaller.getInstance().marshall(outputsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (createJobRequest.getOutputKeyPrefix() != null) {
                jsonWriter.key("OutputKeyPrefix").value(createJobRequest.getOutputKeyPrefix());
            }
            if (!(playlistsList = (SdkInternalList)createJobRequest.getPlaylists()).isEmpty() || !playlistsList.isAutoConstruct()) {
                jsonWriter.key("Playlists");
                jsonWriter.array();
                for (CreateJobPlaylist playlistsListValue : playlistsList) {
                    if (playlistsListValue == null) continue;
                    CreateJobPlaylistJsonMarshaller.getInstance().marshall(playlistsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(userMetadataMap = (SdkInternalMap)createJobRequest.getUserMetadata()).isEmpty() || !userMetadataMap.isAutoConstruct()) {
                jsonWriter.key("UserMetadata");
                jsonWriter.object();
                for (Map.Entry userMetadataMapValue : userMetadataMap.entrySet()) {
                    if (userMetadataMapValue.getValue() == null) continue;
                    jsonWriter.key((String)userMetadataMapValue.getKey());
                    jsonWriter.value(userMetadataMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

