/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.ContainerOverride;
import com.amazonaws.services.ecs.model.TaskOverride;
import com.amazonaws.services.ecs.model.transform.ContainerOverrideJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class TaskOverrideJsonMarshaller {
    private static TaskOverrideJsonMarshaller instance;

    public void marshall(TaskOverride taskOverride, JSONWriter jsonWriter) {
        if (taskOverride == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            SdkInternalList containerOverridesList = (SdkInternalList)taskOverride.getContainerOverrides();
            if (!containerOverridesList.isEmpty() || !containerOverridesList.isAutoConstruct()) {
                jsonWriter.key("containerOverrides");
                jsonWriter.array();
                for (ContainerOverride containerOverridesListValue : containerOverridesList) {
                    if (containerOverridesListValue == null) continue;
                    ContainerOverrideJsonMarshaller.getInstance().marshall(containerOverridesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TaskOverrideJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TaskOverrideJsonMarshaller();
        }
        return instance;
    }
}

