/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.route53domains.model.Nameserver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateDomainNameserversRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainName;
    private String fIAuthKey;
    private ListWithAutoConstructFlag<Nameserver> nameservers;

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public UpdateDomainNameserversRequest withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public String getFIAuthKey() {
        return this.fIAuthKey;
    }

    public void setFIAuthKey(String fIAuthKey) {
        this.fIAuthKey = fIAuthKey;
    }

    public UpdateDomainNameserversRequest withFIAuthKey(String fIAuthKey) {
        this.fIAuthKey = fIAuthKey;
        return this;
    }

    public List<Nameserver> getNameservers() {
        if (this.nameservers == null) {
            this.nameservers = new ListWithAutoConstructFlag();
            this.nameservers.setAutoConstruct(true);
        }
        return this.nameservers;
    }

    public void setNameservers(Collection<Nameserver> nameservers) {
        if (nameservers == null) {
            this.nameservers = null;
            return;
        }
        ListWithAutoConstructFlag nameserversCopy = new ListWithAutoConstructFlag(nameservers.size());
        nameserversCopy.addAll(nameservers);
        this.nameservers = nameserversCopy;
    }

    public UpdateDomainNameserversRequest withNameservers(Nameserver ... nameservers) {
        if (this.getNameservers() == null) {
            this.setNameservers(new ArrayList<Nameserver>(nameservers.length));
        }
        for (Nameserver value : nameservers) {
            this.getNameservers().add(value);
        }
        return this;
    }

    public UpdateDomainNameserversRequest withNameservers(Collection<Nameserver> nameservers) {
        if (nameservers == null) {
            this.nameservers = null;
        } else {
            ListWithAutoConstructFlag nameserversCopy = new ListWithAutoConstructFlag(nameservers.size());
            nameserversCopy.addAll(nameservers);
            this.nameservers = nameserversCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: " + this.getDomainName() + ",");
        }
        if (this.getFIAuthKey() != null) {
            sb.append("FIAuthKey: " + this.getFIAuthKey() + ",");
        }
        if (this.getNameservers() != null) {
            sb.append("Nameservers: " + this.getNameservers());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getFIAuthKey() == null ? 0 : this.getFIAuthKey().hashCode());
        hashCode = 31 * hashCode + (this.getNameservers() == null ? 0 : this.getNameservers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainNameserversRequest)) {
            return false;
        }
        UpdateDomainNameserversRequest other = (UpdateDomainNameserversRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getFIAuthKey() == null ^ this.getFIAuthKey() == null) {
            return false;
        }
        if (other.getFIAuthKey() != null && !other.getFIAuthKey().equals(this.getFIAuthKey())) {
            return false;
        }
        if (other.getNameservers() == null ^ this.getNameservers() == null) {
            return false;
        }
        return other.getNameservers() == null || other.getNameservers().equals(this.getNameservers());
    }

    @Override
    public UpdateDomainNameserversRequest clone() {
        return (UpdateDomainNameserversRequest)super.clone();
    }
}

