/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.logs.model.ExportTask;
import com.amazonaws.services.logs.model.transform.ExportTaskExecutionInfoJsonMarshaller;
import com.amazonaws.services.logs.model.transform.ExportTaskStatusJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ExportTaskJsonMarshaller {
    private static ExportTaskJsonMarshaller instance;

    public void marshall(ExportTask exportTask, JSONWriter jsonWriter) {
        if (exportTask == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (exportTask.getTaskId() != null) {
                jsonWriter.key("taskId").value(exportTask.getTaskId());
            }
            if (exportTask.getTaskName() != null) {
                jsonWriter.key("taskName").value(exportTask.getTaskName());
            }
            if (exportTask.getLogGroupName() != null) {
                jsonWriter.key("logGroupName").value(exportTask.getLogGroupName());
            }
            if (exportTask.getFrom() != null) {
                jsonWriter.key("from").value(exportTask.getFrom());
            }
            if (exportTask.getTo() != null) {
                jsonWriter.key("to").value(exportTask.getTo());
            }
            if (exportTask.getDestination() != null) {
                jsonWriter.key("destination").value(exportTask.getDestination());
            }
            if (exportTask.getDestinationPrefix() != null) {
                jsonWriter.key("destinationPrefix").value(exportTask.getDestinationPrefix());
            }
            if (exportTask.getStatus() != null) {
                jsonWriter.key("status");
                ExportTaskStatusJsonMarshaller.getInstance().marshall(exportTask.getStatus(), jsonWriter);
            }
            if (exportTask.getExecutionInfo() != null) {
                jsonWriter.key("executionInfo");
                ExportTaskExecutionInfoJsonMarshaller.getInstance().marshall(exportTask.getExecutionInfo(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ExportTaskJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ExportTaskJsonMarshaller();
        }
        return instance;
    }
}

