/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.Attribute;
import com.amazonaws.services.directory.model.Computer;
import com.amazonaws.services.directory.model.transform.AttributeJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ComputerJsonMarshaller {
    private static ComputerJsonMarshaller instance;

    public void marshall(Computer computer, JSONWriter jsonWriter) {
        if (computer == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList computerAttributesList;
            jsonWriter.object();
            if (computer.getComputerId() != null) {
                jsonWriter.key("ComputerId").value(computer.getComputerId());
            }
            if (computer.getComputerName() != null) {
                jsonWriter.key("ComputerName").value(computer.getComputerName());
            }
            if (!(computerAttributesList = (SdkInternalList)computer.getComputerAttributes()).isEmpty() || !computerAttributesList.isAutoConstruct()) {
                jsonWriter.key("ComputerAttributes");
                jsonWriter.array();
                for (Attribute computerAttributesListValue : computerAttributesList) {
                    if (computerAttributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(computerAttributesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ComputerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ComputerJsonMarshaller();
        }
        return instance;
    }
}

