/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecr.model.CompleteLayerUploadRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class CompleteLayerUploadRequestMarshaller
implements Marshaller<Request<CompleteLayerUploadRequest>, CompleteLayerUploadRequest> {
    @Override
    public Request<CompleteLayerUploadRequest> marshall(CompleteLayerUploadRequest completeLayerUploadRequest) {
        if (completeLayerUploadRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CompleteLayerUploadRequest> request = new DefaultRequest<CompleteLayerUploadRequest>(completeLayerUploadRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.CompleteLayerUpload");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> layerDigestsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (completeLayerUploadRequest.getRegistryId() != null) {
                jsonWriter.key("registryId").value(completeLayerUploadRequest.getRegistryId());
            }
            if (completeLayerUploadRequest.getRepositoryName() != null) {
                jsonWriter.key("repositoryName").value(completeLayerUploadRequest.getRepositoryName());
            }
            if (completeLayerUploadRequest.getUploadId() != null) {
                jsonWriter.key("uploadId").value(completeLayerUploadRequest.getUploadId());
            }
            if ((layerDigestsList = completeLayerUploadRequest.getLayerDigests()) != null) {
                jsonWriter.key("layerDigests");
                jsonWriter.array();
                for (String layerDigestsListValue : layerDigestsList) {
                    if (layerDigestsListValue == null) continue;
                    jsonWriter.value(layerDigestsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

