/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directory.model.CreateAliasRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateAliasRequestMarshaller
implements Marshaller<Request<CreateAliasRequest>, CreateAliasRequest> {
    @Override
    public Request<CreateAliasRequest> marshall(CreateAliasRequest createAliasRequest) {
        if (createAliasRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateAliasRequest> request = new DefaultRequest<CreateAliasRequest>(createAliasRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.CreateAlias");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createAliasRequest.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value(createAliasRequest.getDirectoryId());
            }
            if (createAliasRequest.getAlias() != null) {
                jsonWriter.key("Alias").value(createAliasRequest.getAlias());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

