/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.support.model.DescribeServicesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeServicesRequestMarshaller
implements Marshaller<Request<DescribeServicesRequest>, DescribeServicesRequest> {
    @Override
    public Request<DescribeServicesRequest> marshall(DescribeServicesRequest describeServicesRequest) {
        if (describeServicesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeServicesRequest> request = new DefaultRequest<DescribeServicesRequest>(describeServicesRequest, "AWSSupport");
        request.addHeader("X-Amz-Target", "AWSSupport_20130415.DescribeServices");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            SdkInternalList serviceCodeListList = (SdkInternalList)describeServicesRequest.getServiceCodeList();
            if (!serviceCodeListList.isEmpty() || !serviceCodeListList.isAutoConstruct()) {
                jsonWriter.key("serviceCodeList");
                jsonWriter.array();
                for (String serviceCodeListListValue : serviceCodeListList) {
                    if (serviceCodeListListValue == null) continue;
                    jsonWriter.value(serviceCodeListListValue);
                }
                jsonWriter.endArray();
            }
            if (describeServicesRequest.getLanguage() != null) {
                jsonWriter.key("language").value(describeServicesRequest.getLanguage());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

