/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.service.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.service.codepipeline.model.Artifact;
import com.amazonaws.service.codepipeline.model.JobData;
import com.amazonaws.service.codepipeline.model.transform.AWSSessionCredentialsJsonMarshaller;
import com.amazonaws.service.codepipeline.model.transform.ActionConfigurationJsonMarshaller;
import com.amazonaws.service.codepipeline.model.transform.ActionTypeIdJsonMarshaller;
import com.amazonaws.service.codepipeline.model.transform.ArtifactJsonMarshaller;
import com.amazonaws.service.codepipeline.model.transform.PipelineContextJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class JobDataJsonMarshaller {
    private static JobDataJsonMarshaller instance;

    public void marshall(JobData jobData, JSONWriter jsonWriter) {
        if (jobData == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Artifact> outputArtifactsList;
            List<Artifact> inputArtifactsList;
            jsonWriter.object();
            if (jobData.getActionTypeId() != null) {
                jsonWriter.key("actionTypeId");
                ActionTypeIdJsonMarshaller.getInstance().marshall(jobData.getActionTypeId(), jsonWriter);
            }
            if (jobData.getActionConfiguration() != null) {
                jsonWriter.key("actionConfiguration");
                ActionConfigurationJsonMarshaller.getInstance().marshall(jobData.getActionConfiguration(), jsonWriter);
            }
            if (jobData.getPipelineContext() != null) {
                jsonWriter.key("pipelineContext");
                PipelineContextJsonMarshaller.getInstance().marshall(jobData.getPipelineContext(), jsonWriter);
            }
            if ((inputArtifactsList = jobData.getInputArtifacts()) != null) {
                jsonWriter.key("inputArtifacts");
                jsonWriter.array();
                for (Artifact inputArtifactsListValue : inputArtifactsList) {
                    if (inputArtifactsListValue == null) continue;
                    ArtifactJsonMarshaller.getInstance().marshall(inputArtifactsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if ((outputArtifactsList = jobData.getOutputArtifacts()) != null) {
                jsonWriter.key("outputArtifacts");
                jsonWriter.array();
                for (Artifact outputArtifactsListValue : outputArtifactsList) {
                    if (outputArtifactsListValue == null) continue;
                    ArtifactJsonMarshaller.getInstance().marshall(outputArtifactsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (jobData.getArtifactCredentials() != null) {
                jsonWriter.key("artifactCredentials");
                AWSSessionCredentialsJsonMarshaller.getInstance().marshall(jobData.getArtifactCredentials(), jsonWriter);
            }
            if (jobData.getContinuationToken() != null) {
                jsonWriter.key("continuationToken").value(jobData.getContinuationToken());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobDataJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobDataJsonMarshaller();
        }
        return instance;
    }
}

