/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddPermissionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String queueUrl;
    private String label;
    private ListWithAutoConstructFlag<String> aWSAccountIds;
    private ListWithAutoConstructFlag<String> actions;

    public AddPermissionRequest() {
    }

    public AddPermissionRequest(String queueUrl, String label, List<String> aWSAccountIds, List<String> actions) {
        this.setQueueUrl(queueUrl);
        this.setLabel(label);
        this.setAWSAccountIds(aWSAccountIds);
        this.setActions(actions);
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public AddPermissionRequest withQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public AddPermissionRequest withLabel(String label) {
        this.label = label;
        return this;
    }

    public List<String> getAWSAccountIds() {
        if (this.aWSAccountIds == null) {
            this.aWSAccountIds = new ListWithAutoConstructFlag();
            this.aWSAccountIds.setAutoConstruct(true);
        }
        return this.aWSAccountIds;
    }

    public void setAWSAccountIds(Collection<String> aWSAccountIds) {
        if (aWSAccountIds == null) {
            this.aWSAccountIds = null;
            return;
        }
        ListWithAutoConstructFlag aWSAccountIdsCopy = new ListWithAutoConstructFlag(aWSAccountIds.size());
        aWSAccountIdsCopy.addAll(aWSAccountIds);
        this.aWSAccountIds = aWSAccountIdsCopy;
    }

    public AddPermissionRequest withAWSAccountIds(String ... aWSAccountIds) {
        if (this.getAWSAccountIds() == null) {
            this.setAWSAccountIds(new ArrayList<String>(aWSAccountIds.length));
        }
        for (String value : aWSAccountIds) {
            this.getAWSAccountIds().add(value);
        }
        return this;
    }

    public AddPermissionRequest withAWSAccountIds(Collection<String> aWSAccountIds) {
        if (aWSAccountIds == null) {
            this.aWSAccountIds = null;
        } else {
            ListWithAutoConstructFlag aWSAccountIdsCopy = new ListWithAutoConstructFlag(aWSAccountIds.size());
            aWSAccountIdsCopy.addAll(aWSAccountIds);
            this.aWSAccountIds = aWSAccountIdsCopy;
        }
        return this;
    }

    public List<String> getActions() {
        if (this.actions == null) {
            this.actions = new ListWithAutoConstructFlag();
            this.actions.setAutoConstruct(true);
        }
        return this.actions;
    }

    public void setActions(Collection<String> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        ListWithAutoConstructFlag actionsCopy = new ListWithAutoConstructFlag(actions.size());
        actionsCopy.addAll(actions);
        this.actions = actionsCopy;
    }

    public AddPermissionRequest withActions(String ... actions) {
        if (this.getActions() == null) {
            this.setActions(new ArrayList<String>(actions.length));
        }
        for (String value : actions) {
            this.getActions().add(value);
        }
        return this;
    }

    public AddPermissionRequest withActions(Collection<String> actions) {
        if (actions == null) {
            this.actions = null;
        } else {
            ListWithAutoConstructFlag actionsCopy = new ListWithAutoConstructFlag(actions.size());
            actionsCopy.addAll(actions);
            this.actions = actionsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueueUrl() != null) {
            sb.append("QueueUrl: " + this.getQueueUrl() + ",");
        }
        if (this.getLabel() != null) {
            sb.append("Label: " + this.getLabel() + ",");
        }
        if (this.getAWSAccountIds() != null) {
            sb.append("AWSAccountIds: " + this.getAWSAccountIds() + ",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: " + this.getActions());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueueUrl() == null ? 0 : this.getQueueUrl().hashCode());
        hashCode = 31 * hashCode + (this.getLabel() == null ? 0 : this.getLabel().hashCode());
        hashCode = 31 * hashCode + (this.getAWSAccountIds() == null ? 0 : this.getAWSAccountIds().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest)obj;
        if (other.getQueueUrl() == null ^ this.getQueueUrl() == null) {
            return false;
        }
        if (other.getQueueUrl() != null && !other.getQueueUrl().equals(this.getQueueUrl())) {
            return false;
        }
        if (other.getLabel() == null ^ this.getLabel() == null) {
            return false;
        }
        if (other.getLabel() != null && !other.getLabel().equals(this.getLabel())) {
            return false;
        }
        if (other.getAWSAccountIds() == null ^ this.getAWSAccountIds() == null) {
            return false;
        }
        if (other.getAWSAccountIds() != null && !other.getAWSAccountIds().equals(this.getAWSAccountIds())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        return other.getActions() == null || other.getActions().equals(this.getActions());
    }

    @Override
    public AddPermissionRequest clone() {
        return (AddPermissionRequest)super.clone();
    }
}

