/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class SendMessageBatchRequestMarshaller
implements Marshaller<Request<SendMessageBatchRequest>, SendMessageBatchRequest> {
    @Override
    public Request<SendMessageBatchRequest> marshall(SendMessageBatchRequest sendMessageBatchRequest) {
        if (sendMessageBatchRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendMessageBatchRequest> request = new DefaultRequest<SendMessageBatchRequest>(sendMessageBatchRequest, "AmazonSQS");
        request.addParameter("Action", "SendMessageBatch");
        request.addParameter("Version", "2012-11-05");
        if (sendMessageBatchRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(sendMessageBatchRequest.getQueueUrl()));
        }
        List<SendMessageBatchRequestEntry> entriesList = sendMessageBatchRequest.getEntries();
        int entriesListIndex = 1;
        for (SendMessageBatchRequestEntry entriesListValue : entriesList) {
            SendMessageBatchRequestEntry sendMessageBatchRequestEntryMember = entriesListValue;
            if (sendMessageBatchRequestEntryMember != null) {
                if (sendMessageBatchRequestEntryMember.getId() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".Id", StringUtils.fromString(sendMessageBatchRequestEntryMember.getId()));
                }
                if (sendMessageBatchRequestEntryMember.getMessageBody() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageBody", StringUtils.fromString(sendMessageBatchRequestEntryMember.getMessageBody()));
                }
                if (sendMessageBatchRequestEntryMember.getDelaySeconds() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".DelaySeconds", StringUtils.fromInteger(sendMessageBatchRequestEntryMember.getDelaySeconds()));
                }
                if (sendMessageBatchRequestEntryMember != null && sendMessageBatchRequestEntryMember.getMessageAttributes() != null) {
                    int messageAttributesListIndex = 1;
                    for (Map.Entry<String, MessageAttributeValue> messageAttributesListValue : sendMessageBatchRequestEntryMember.getMessageAttributes().entrySet()) {
                        MessageAttributeValue messageAttributeValueValue;
                        if (messageAttributesListValue.getKey() != null) {
                            request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Name", StringUtils.fromString(messageAttributesListValue.getKey()));
                        }
                        if ((messageAttributeValueValue = messageAttributesListValue.getValue()) != null) {
                            if (messageAttributeValueValue.getStringValue() != null) {
                                request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.StringValue", StringUtils.fromString(messageAttributeValueValue.getStringValue()));
                            }
                            if (messageAttributeValueValue.getBinaryValue() != null) {
                                request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.BinaryValue", StringUtils.fromByteBuffer(messageAttributeValueValue.getBinaryValue()));
                            }
                            List<String> stringListValuesList = messageAttributeValueValue.getStringListValues();
                            int stringListValuesListIndex = 1;
                            for (String stringListValuesListValue : stringListValuesList) {
                                if (stringListValuesListValue != null) {
                                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.StringListValue." + stringListValuesListIndex, StringUtils.fromString(stringListValuesListValue));
                                }
                                ++stringListValuesListIndex;
                            }
                            List<ByteBuffer> binaryListValuesList = messageAttributeValueValue.getBinaryListValues();
                            int binaryListValuesListIndex = 1;
                            for (ByteBuffer binaryListValuesListValue : binaryListValuesList) {
                                if (binaryListValuesListValue != null) {
                                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.BinaryListValue." + binaryListValuesListIndex, StringUtils.fromByteBuffer(binaryListValuesListValue));
                                }
                                ++binaryListValuesListIndex;
                            }
                            if (messageAttributeValueValue.getDataType() != null) {
                                request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.DataType", StringUtils.fromString(messageAttributeValueValue.getDataType()));
                            }
                        }
                        ++messageAttributesListIndex;
                    }
                }
            }
            ++entriesListIndex;
        }
        return request;
    }
}

