/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CopyDBSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String sourceDBSnapshotIdentifier;
    private String targetDBSnapshotIdentifier;
    private ListWithAutoConstructFlag<Tag> tags;
    private Boolean copyTags;

    public String getSourceDBSnapshotIdentifier() {
        return this.sourceDBSnapshotIdentifier;
    }

    public void setSourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
        this.sourceDBSnapshotIdentifier = sourceDBSnapshotIdentifier;
    }

    public CopyDBSnapshotRequest withSourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
        this.sourceDBSnapshotIdentifier = sourceDBSnapshotIdentifier;
        return this;
    }

    public String getTargetDBSnapshotIdentifier() {
        return this.targetDBSnapshotIdentifier;
    }

    public void setTargetDBSnapshotIdentifier(String targetDBSnapshotIdentifier) {
        this.targetDBSnapshotIdentifier = targetDBSnapshotIdentifier;
    }

    public CopyDBSnapshotRequest withTargetDBSnapshotIdentifier(String targetDBSnapshotIdentifier) {
        this.targetDBSnapshotIdentifier = targetDBSnapshotIdentifier;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public CopyDBSnapshotRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public CopyDBSnapshotRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public Boolean isCopyTags() {
        return this.copyTags;
    }

    public void setCopyTags(Boolean copyTags) {
        this.copyTags = copyTags;
    }

    public CopyDBSnapshotRequest withCopyTags(Boolean copyTags) {
        this.copyTags = copyTags;
        return this;
    }

    public Boolean getCopyTags() {
        return this.copyTags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceDBSnapshotIdentifier() != null) {
            sb.append("SourceDBSnapshotIdentifier: " + this.getSourceDBSnapshotIdentifier() + ",");
        }
        if (this.getTargetDBSnapshotIdentifier() != null) {
            sb.append("TargetDBSnapshotIdentifier: " + this.getTargetDBSnapshotIdentifier() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.isCopyTags() != null) {
            sb.append("CopyTags: " + this.isCopyTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceDBSnapshotIdentifier() == null ? 0 : this.getSourceDBSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTargetDBSnapshotIdentifier() == null ? 0 : this.getTargetDBSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.isCopyTags() == null ? 0 : this.isCopyTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDBSnapshotRequest)) {
            return false;
        }
        CopyDBSnapshotRequest other = (CopyDBSnapshotRequest)obj;
        if (other.getSourceDBSnapshotIdentifier() == null ^ this.getSourceDBSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getSourceDBSnapshotIdentifier() != null && !other.getSourceDBSnapshotIdentifier().equals(this.getSourceDBSnapshotIdentifier())) {
            return false;
        }
        if (other.getTargetDBSnapshotIdentifier() == null ^ this.getTargetDBSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getTargetDBSnapshotIdentifier() != null && !other.getTargetDBSnapshotIdentifier().equals(this.getTargetDBSnapshotIdentifier())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.isCopyTags() == null ^ this.isCopyTags() == null) {
            return false;
        }
        return other.isCopyTags() == null || other.isCopyTags().equals(this.isCopyTags());
    }

    @Override
    public CopyDBSnapshotRequest clone() {
        return (CopyDBSnapshotRequest)super.clone();
    }
}

