/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.ListAssessmentsRequest;
import com.amazonaws.services.inspector.model.transform.AssessmentsFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class ListAssessmentsRequestMarshaller
implements Marshaller<Request<ListAssessmentsRequest>, ListAssessmentsRequest> {
    @Override
    public Request<ListAssessmentsRequest> marshall(ListAssessmentsRequest listAssessmentsRequest) {
        if (listAssessmentsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListAssessmentsRequest> request = new DefaultRequest<ListAssessmentsRequest>(listAssessmentsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.ListAssessments");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            List<String> applicationArnsList = listAssessmentsRequest.getApplicationArns();
            if (applicationArnsList != null) {
                jsonWriter.key("applicationArns");
                jsonWriter.array();
                for (String applicationArnsListValue : applicationArnsList) {
                    if (applicationArnsListValue == null) continue;
                    jsonWriter.value(applicationArnsListValue);
                }
                jsonWriter.endArray();
            }
            if (listAssessmentsRequest.getFilter() != null) {
                jsonWriter.key("filter");
                AssessmentsFilterJsonMarshaller.getInstance().marshall(listAssessmentsRequest.getFilter(), jsonWriter);
            }
            if (listAssessmentsRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value(listAssessmentsRequest.getNextToken());
            }
            if (listAssessmentsRequest.getMaxResults() != null) {
                jsonWriter.key("maxResults").value(listAssessmentsRequest.getMaxResults());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

