/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudsearchdomain.model.SearchRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SearchRequestMarshaller
implements Marshaller<Request<SearchRequest>, SearchRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<SearchRequest> marshall(SearchRequest searchRequest) {
        String value;
        String name;
        if (searchRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SearchRequest> request = new DefaultRequest<SearchRequest>(searchRequest, "AmazonCloudSearchDomain");
        String target = "AmazonCloudSearch2013.Search";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("Cursor")) {
            name = DYNAMIC_QUERY_PARAMS.get("Cursor");
            String string = value = searchRequest.getCursor() == null ? null : StringUtils.fromString(searchRequest.getCursor());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Cursor}", searchRequest.getCursor() == null ? "" : StringUtils.fromString(searchRequest.getCursor()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Expr")) {
            name = DYNAMIC_QUERY_PARAMS.get("Expr");
            String string = value = searchRequest.getExpr() == null ? null : StringUtils.fromString(searchRequest.getExpr());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Expr}", searchRequest.getExpr() == null ? "" : StringUtils.fromString(searchRequest.getExpr()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Facet")) {
            name = DYNAMIC_QUERY_PARAMS.get("Facet");
            String string = value = searchRequest.getFacet() == null ? null : StringUtils.fromString(searchRequest.getFacet());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Facet}", searchRequest.getFacet() == null ? "" : StringUtils.fromString(searchRequest.getFacet()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("FilterQuery")) {
            name = DYNAMIC_QUERY_PARAMS.get("FilterQuery");
            String string = value = searchRequest.getFilterQuery() == null ? null : StringUtils.fromString(searchRequest.getFilterQuery());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{FilterQuery}", searchRequest.getFilterQuery() == null ? "" : StringUtils.fromString(searchRequest.getFilterQuery()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Highlight")) {
            name = DYNAMIC_QUERY_PARAMS.get("Highlight");
            String string = value = searchRequest.getHighlight() == null ? null : StringUtils.fromString(searchRequest.getHighlight());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Highlight}", searchRequest.getHighlight() == null ? "" : StringUtils.fromString(searchRequest.getHighlight()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Partial")) {
            name = DYNAMIC_QUERY_PARAMS.get("Partial");
            String string = value = searchRequest.isPartial() == null ? null : StringUtils.fromBoolean(searchRequest.isPartial());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Partial}", searchRequest.isPartial() == null ? "" : StringUtils.fromBoolean(searchRequest.isPartial()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Query")) {
            name = DYNAMIC_QUERY_PARAMS.get("Query");
            String string = value = searchRequest.getQuery() == null ? null : StringUtils.fromString(searchRequest.getQuery());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Query}", searchRequest.getQuery() == null ? "" : StringUtils.fromString(searchRequest.getQuery()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("QueryOptions")) {
            name = DYNAMIC_QUERY_PARAMS.get("QueryOptions");
            String string = value = searchRequest.getQueryOptions() == null ? null : StringUtils.fromString(searchRequest.getQueryOptions());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{QueryOptions}", searchRequest.getQueryOptions() == null ? "" : StringUtils.fromString(searchRequest.getQueryOptions()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("QueryParser")) {
            name = DYNAMIC_QUERY_PARAMS.get("QueryParser");
            String string = value = searchRequest.getQueryParser() == null ? null : StringUtils.fromString(searchRequest.getQueryParser());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{QueryParser}", searchRequest.getQueryParser() == null ? "" : StringUtils.fromString(searchRequest.getQueryParser()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Return")) {
            name = DYNAMIC_QUERY_PARAMS.get("Return");
            String string = value = searchRequest.getReturn() == null ? null : StringUtils.fromString(searchRequest.getReturn());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Return}", searchRequest.getReturn() == null ? "" : StringUtils.fromString(searchRequest.getReturn()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Size")) {
            name = DYNAMIC_QUERY_PARAMS.get("Size");
            String string = value = searchRequest.getSize() == null ? null : StringUtils.fromLong(searchRequest.getSize());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Size}", searchRequest.getSize() == null ? "" : StringUtils.fromLong(searchRequest.getSize()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Sort")) {
            name = DYNAMIC_QUERY_PARAMS.get("Sort");
            String string = value = searchRequest.getSort() == null ? null : StringUtils.fromString(searchRequest.getSort());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Sort}", searchRequest.getSort() == null ? "" : StringUtils.fromString(searchRequest.getSort()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Start")) {
            name = DYNAMIC_QUERY_PARAMS.get("Start");
            String string = value = searchRequest.getStart() == null ? null : StringUtils.fromLong(searchRequest.getStart());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Start}", searchRequest.getStart() == null ? "" : StringUtils.fromLong(searchRequest.getStart()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }

    static {
        String path = "/2013-01-01/search?format=sdk&pretty=true&cursor={Cursor}&expr={Expr}&facet={Facet}&fq={FilterQuery}&highlight={Highlight}&partial={Partial}&q={Query}&q.options={QueryOptions}&q.parser={QueryParser}&return={Return}&size={Size}&sort={Sort}&start={Start}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

